% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.D3mirt}
\alias{summary.D3mirt}
\title{Summary Function for \code{D3mirt()}}
\usage{
\method{summary}{D3mirt}(object, ..., digits = 4)
}
\arguments{
\item{object}{S3 object of class \code{D3mirt}.}

\item{...}{Additional arguments.}

\item{digits}{User can adjust the number of digits shown per estimate. The default is \code{digits = 4}.}
}
\value{
Tables containing \emph{a} and \emph{d} parameters, multidimensional discrimination (MDISC), multidimensional item difficulty (MDIFF), direction cosines, and degrees for vector angles for items.
If constructs were used in the estimation process, the summary function will also show tables for direction cosines, and degrees for construct vectors as well as directional discrimination (DDISC) parameters.
}
\description{
The \code{summary.D3mirt()} function presents a compressed output from the \code{\link[=D3mirt]{D3mirt()}} S3 object.
}
\examples{
\donttest{
# Load data
data("anes0809offwaves")
x <- anes0809offwaves
x <- x[,3:22] # Remove columns for age and gender

# Fit a three-dimensional graded response model with orthogonal factors
spec <- '  F1 = 1-20
           F2 = 1-20
           F3 = 1-20

           START=(W7Q3,a2,0)
           START=(W7Q3,a3,0)

           START=(W7Q20,a3,0)

           FIXED=(W7Q3,a2)
           FIXED=(W7Q3,a3)

           FIXED=(W7Q20,a3) '


mod1 <- mirt::mirt(x,
                   spec,
                   itemtype = 'graded',
                   SE = TRUE,
                   method = 'QMCEM')

# Assign a data frame with factor loadings (located in the first three columns in mod1),
# and difficulty parameters (columns 4-8 in mod1) with mirt::coef and $'items'[,1:8]))
d <- data.frame(mirt::coef(mod1,
                           simplify=TRUE)$'items'[,1:8])

# Call D3mirt() and create list of constructs
c <- list(list(1,3,4,6,8), list(2,5,7,9,10))
g <- D3mirt(d, c)

# Call to summary
summary(g)
}
}
\author{
Erik Forsberg
}
