% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_cluster_gates.R, R/gates.R
\name{gates.apply_cluster_gates}
\alias{gates}
\alias{gates.apply_cluster_gates}
\title{Gates}
\usage{
gates.apply_cluster_gates(UserSession, experiment_id, name, clusters,
  channel_name, integer_min = 1, integer_max = max(clusters),
  grouped = FALSE, timeout = 60)
}
\arguments{
\item{UserSession}{Cytobank UserSession object (created via the \link[CytobankAPI]{authenticate} function)}

\item{experiment_id}{integer representing an \link[CytobankAPI]{experiments} ID}

\item{name}{character representing a cluster prefix (if grouped=FALSE) or multicluster gate name}

\item{clusters}{integer vector representing the clusters to gate\cr
- There are 2 modes of operation:\cr
  1) \code{grouped=FALSE}: clusters represent individual integer clusters to gate, this will create \strong{multiple gates} that represents \strong{multiple individual populations}\cr
  2) \code{grouped=TRUE}:  clusters represent a multi-integer cluster to gate, this will create \strong{one gate} that represents \strong{one population} around the integer clusters specified}

\item{channel_name}{character representing the channel short name}

\item{integer_min}{integer representing the minimum cluster integer for setting scales \strong{[optional]}\cr
- The default is set to 1, this assumes clusters begin at 1, but can be changed if there is any +/- offset\cr
  - The minimum scale will be set to integer_min-1 (0 by)}

\item{integer_max}{integer representing the maximum cluster integer for setting scales \strong{[optional]}\cr
- The default is the maximum number presented within the \code{clusters} vector, but can be set to any integer\cr
  - The max scale will be set to integer_max+1}

\item{grouped}{logical representing whether to gate a vector of integer clusters as individual integer clusters (grouped=FALSE), or together as a single multicluster (grouped=TRUE)}

\item{timeout}{integer representing the request timeout time in seconds \strong{[optional]}}
}
\description{
Gates High Level Functions
}
\details{
\code{gates.apply_cluster_gates} Apply cluster gate(s) to specific clusters via an integer vector
}
\examples{
\donttest{gates.apply_cluster_gates(cyto_session, 22, name="cluster_names",
  clusters=c(1,5,9), channel_name="cluster_id")
}
}

