/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.TableRowSorter;
import org.mutoss.gui.CrossoverGUI;
import org.mutoss.gui.Design;
import org.mutoss.gui.DesignTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesignTable
extends JTable {
    TableRowSorter<DesignTableModel> sorter = new TableRowSorter<DesignTableModel>(this.getModel());

    public DesignTable(CrossoverGUI gui) {
        super(new DesignTableModel(gui));
        this.setRowSorter(this.sorter);
    }

    @Override
    public DesignTableModel getModel() {
        return (DesignTableModel)super.getModel();
    }

    public void setDesigns(List<Design> designs) {
        this.getModel().setDesigns(designs);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String tooltip = null;
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        int realRowIndex = this.convertRowIndexToModel(rowIndex);
        int realColumnIndex = this.convertColumnIndexToModel(colIndex);
        if (realColumnIndex == 0) {
            tooltip = this.getModel().getDesigns().get((int)realRowIndex).reference;
        } else if (realColumnIndex != 3) {
            tooltip = super.getToolTipText(e);
        }
        return tooltip;
    }

    private void setExpressionFilter(String expr) {
        try {
            RowFilter rf = RowFilter.regexFilter(expr, 0);
            this.sorter.setRowFilter(rf);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }
}

