% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_ExG.R
\name{make_ExG}
\alias{make_ExG}
\title{Converts a color image into a grayscale image using ExG methodology.}
\usage{
make_ExG(color_image)
}
\arguments{
\item{color_image}{The image to have ExG applied to it}
}
\value{
An image formatted for EBImage commands.
}
\description{
Uses the Excessive Green (ExG) methodology to create a grayscale image of crop rows. The image is first broken down into a dataframe and each pixel is tested then put onto a varying intensity according to the ExG.
}
\details{
The function first reads the image as a data frame with x and y columns for the pixel postion. Reading the data frame as "wide = 'c'" also creates a column for red, green, and blue intensity. Each color column is then normalized and the normal values of the colors are put into the ExG equation, creating a new ExG column for each pixel. The values of the ExG are then treated as a 1D array and transformed into a format for the EBImage package commands.
}
\examples{
\donttest{grayscale <- make_ExG(color_image)}

}
