% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.cds.R
\name{calibrate.cds}
\alias{calibrate.cds}
\title{Calibrate the default intensities to market CDS data}
\usage{
calibrate.cds(r, t, T, cdsrate, ...)
}
\arguments{
\item{r}{interest rates.}

\item{t}{premiums timetable.}

\item{T}{CDS maturities.}

\item{cdsrate}{CDS rates from market.}

\item{...}{additional parameters used in \code{cds} function.}
}
\value{
returns an object of class \code{list} with calculated intensities and the
error occurred in the minimization procedure.
}
\description{
Compares CDS rates quoted on market with theoric CDS rates and looks for default intensities
that correspond to real market CDS rates trough a minimization problem of an objective
function.
}
\details{
Inside \code{calibrate.cds}, the function \code{err.cds} takes the input a
vector of intensities and return the mean error occurred estimating CDS rates with
\code{cds}. In particular such error is calculated as:
\deqn{\frac{1}{n}\sum_{i=1}^n (c^{ds}-c^{ds}_{mkt})^2.} This quantity is a function of default intensities and is the our objective
  function to be minimized in order to take optimal solutions for intensities.
}
\examples{
calibrate.cds( r = cdsdata$ED.Zero.Curve, t = seq(.5, 30, by = 0.5),
               T = c(1, 2, 3, 4, 5, 7, 10, 20, 30), cdsrate = cdsdata$Par.spread, RR = 0.4)

}
\references{
David Lando (2004) Credit risk modeling

Damiano Brigo, Massimo Morini, Andrea Pallavicini (2013)
Counterparty Credit Risk, Collateral and Funding.
With Pricing Cases for All Asset Classes
}
