% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/library--data_prep--smooth_tools--ts_trend_gen.R
\name{expSmoothMod}
\alias{expSmoothMod}
\title{expSmoothMod
Add a column of the smoothed values using exponential smoothing}
\usage{
expSmoothMod(DF, InVar, OutVar, alpha = "guess", beta = "guess", Filter = NULL)
}
\arguments{
\item{DF}{The DF we are to add a exponential smoothing column to}

\item{InVar}{The column to be smoothed}

\item{OutVar}{The name of the new column}

\item{alpha}{The alpha fed into forecast exponential smoothing. if it equals "guess" then it
if found using parameterGuess}

\item{beta}{The beta fed into forecast exponential smoothing. if it equals "guess" then it
if found using parameterGuess}

\item{Filter}{Prefilter using the value of a Filter col}
}
\value{
A DF with an extra col with a exp smoothed version of InVar
}
\description{
expSmoothMod
Add a column of the smoothed values using exponential smoothing
}
\examples{
data("Example_data", package = "Covid19Wastewater")
Example_data <- Example_data[Example_data$site == "Green Bay",]
expSmoothMod(Example_data, "N1", "expN1")
}
