% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dWeibull.R
\name{dWeibullCount}
\alias{dWeibullCount}
\alias{dWeibullCount_loglik}
\alias{evWeibullCount}
\title{Probability calculations for Weibull count models}
\usage{
dWeibullCount(
  x,
  shape,
  scale,
  method = c("series_acc", "series_mat", "conv_direct", "conv_naive", "conv_dePril"),
  time = 1,
  log = FALSE,
  conv_steps = 100,
  conv_extrap = TRUE,
  series_terms = 50,
  series_acc_niter = 300,
  series_acc_eps = 1e-10
)

dWeibullCount_loglik(
  x,
  shape,
  scale,
  method = c("series_acc", "series_mat", "conv_direct", "conv_naive", "conv_dePril"),
  time = 1,
  na.rm = TRUE,
  conv_steps = 100,
  conv_extrap = TRUE,
  series_terms = 50,
  series_acc_niter = 300,
  series_acc_eps = 1e-10,
  weights = NULL
)

evWeibullCount(
  xmax,
  shape,
  scale,
  method = c("series_acc", "series_mat", "conv_direct", "conv_naive", "conv_dePril"),
  time = 1,
  conv_steps = 100,
  conv_extrap = TRUE,
  series_terms = 50,
  series_acc_niter = 300,
  series_acc_eps = 1e-10
)
}
\arguments{
\item{x}{integer (vector), the desired count values.}

\item{shape}{numeric (length 1), shape parameter of the Weibull count.}

\item{scale}{numeric (length 1), scale parameter of the Weibull count.}

\item{method}{character, one of the available methods, see details.}

\item{time}{double, length of the observation window (defaults to 1).}

\item{log}{logical, if TRUE, the log of the probability will be returned.}

\item{conv_steps}{numeric, number of steps used for the extrapolation.}

\item{conv_extrap}{logical, should Richardson extrappolation be applied ?}

\item{series_terms}{numeric, number of terms in the series expansion.}

\item{series_acc_niter}{numeric, number of iterations in the
Euler-van Wijngaarden algorithm.}

\item{series_acc_eps}{numeric, tolerance of convergence in the
Euler-van Wijngaarden algorithm.}

\item{na.rm}{logical, if TRUE \code{NA}'s (produced by taking the log of very
small probabilities) will be replaced by the smallest allowed probaility;
default is \code{TRUE}.}

\item{weights}{numeric, vector of weights to apply. If \code{NULL}, a vector
of one's will be applied.}

\item{xmax}{unsigned integer, maximum count to be used.}
}
\value{
for \code{dWeibullCount}, a vector of probabilities
    \eqn{P(x(i)), i = 1, \dots n}, where \eqn{n =} \code{length(x)}.

for \code{dWeibullCount_loglik},
    a double, the log-likelihood of the count process.

for \code{evWeibullCount}, a list with components:
    \item{ExpectedValue}{expected value,}
    \item{Variance}{variance.}
}
\description{
Probability computations for the univariate Weibull count process. Several
methods are provided.
\code{dWeibullCount} computes probabilities.

\code{dWeibullCount_loglik} computes the log-likelihood.

\code{evWeibullCount} computes the expected value and variance.
}
\details{
Argument \code{method} can be used to specify the desired method, as follows:
\describe{
\item{\code{"series_mat"}}{- series expansion using matrix techniques,}
\item{\code{"series_acc"}}{- Euler-van Wijngaarden accelerated series expansion (default),}
\item{\code{"conv_direc"t}}{- direct convolution method of section 2,}
\item{\code{"conv_naive"}}{- naive convolurion described in section 3.1,}
\item{\code{"conv_dePril"}}{- dePril convolution described in section 3.2.}
}
The arguments have sensible default values.
}
