% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelGaussPeak.R
\name{ModelGaussPeak}
\alias{ModelGaussPeak}
\title{Create and modify parameters of an artifical chromatographic peak.}
\usage{
ModelGaussPeak(height = 10^7, width = 4, scan_rate = 10, e = 0,
  ds = 10^7, base_line = 10^2)
}
\arguments{
\item{height}{True peak height (=intensity counts).}

\item{width}{Peak width in time units (preferably seconds).}

\item{scan_rate}{Is determining the resolution of data points per time unit (preferably seconds).}

\item{e}{Error term giving the percent amount of deviation from the ideal gaussian curve for individual data points.}

\item{ds}{Detector saturation. Intensity values will be cut off at this point if requested.}

\item{base_line}{Defines if peak is supposed to have a higher base level.}
}
\value{
Dataframe with columns 'rt' and 'int'.
}
\description{
\code{ModelGaussPeak} will create a potentially overloaded gaussian peak of requested width and height.
}
\details{
The main task of \code{\link{ModelGaussPeak}} is to create peak data in gaussian shape for testing. 
Width is meant in the chromatographic sense, i.e. the time between peak front and tail hitting the baseline.
}
\examples{
ylim <- c(0,10^7)
par(mfrow=c(1,5))
pk <- ModelGaussPeak(height=10^7, width=4, scan_rate=10, e=0, ds=10^7, base_line=10^2)
plot(pk,ylim=ylim,main="standard")
pk <- ModelGaussPeak(height=10^7, width=4, scan_rate=10, e=0, ds=8*10^6, base_line=10^2)
plot(pk,ylim=ylim,main="flat top")
pk <- ModelGaussPeak(height=10^7, width=4, scan_rate=10, e=0, ds=8*10^6, base_line=10^5)
plot(pk,ylim=ylim,main="high baseline")
pk <- ModelGaussPeak(height=10^7, width=4, scan_rate=10, e=0.05, ds=8*10^6, base_line=10^5)
plot(pk,ylim=ylim,main="e=5\%")
pk <- ModelGaussPeak(height=10^7, width=4, scan_rate=5, e=0.05, ds=8*10^6, base_line=10^5)
plot(pk,ylim=ylim,main="sr=5")

}
