% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NucleolusDerivatives.R
\name{perCapitaNucleolus}
\alias{perCapitaNucleolus}
\title{Compute per capita nucleolus}
\usage{
perCapitaNucleolus(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
per capita nucleolus for a specified TU game with n players
}
\description{
perCapitaNucleolus calculates the per capita nucleolus for 
a TU game with a non-empty imputation set specified by a game vector.
}
\examples{
library(CoopGame)
perCapitaNucleolus(c(1, 1, 1, 2, 3, 4, 5))

\donttest{
#Example from YOUNG 1985, p. 68
v<-costSharingGameVector(n=3,C=c(15,20,55,35,61,65,78))
perCapitaNucleolus(v)
#[1]  0.6666667  1.1666667 10.1666667
}

}
\references{
Young H.P. (1985) "Monotonic Solutions of cooperative games", Int. Journal of Game Theory 14(2), pp. 65--72
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
