% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMinimalRights.R
\name{getMinimalRights}
\alias{getMinimalRights}
\alias{getMinimalRightsVector}
\title{Compute minimal rights vector}
\usage{
getMinimalRights(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Vector of minimal rights of each player
}
\description{
Calculates the minimal rights vector.
}
\examples{
library(CoopGame)
getMinimalRights(c(0,0,0,1,0,1,1))

\donttest{
library(CoopGame)
v1 <- c(0,0,0,60,60,60,72)
getMinimalRights(v1)
#[1] 48 48 48

library(CoopGame)
v2 <- c(2,4,5,18,14,9,24) 
getMinimalRights(v2)
#[1] 8 4 5
}

}
\references{
Branzei R., Dimitrov D. and Tijs S. (2006) \emph{Models in cooperative game theory}, Springer, pp. 20--21
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Michael Maerz

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
