% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JohnstonConcept.R
\name{drawJohnstonIndex}
\alias{drawJohnstonIndex}
\title{Draw Johnston index for 3 or 4 players}
\usage{
drawJohnstonIndex(v, holdOn = FALSE, colour = NA, label = TRUE,
  name = "Johnston index")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawJohnstonIndex draws the Johnston index for 3 or 4 players.
}
\examples{
library(CoopGame)
v <- c(0,0,0,1,1,0,1)
drawJohnstonIndex(v)
}
\references{
Johnston R.J. (1978) "On the measurement of power: Some reactions to Laver", Environment and Planning A, pp. 907--914

Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, p. 124
}
