% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cca.R
\name{cca}
\alias{cca}
\title{K-Median Cluster Component Analysis}
\usage{
cca(X, k, control = ccacontrol(...), ...)
}
\arguments{
\item{X}{A n by m data matrix containing preference rankings, in which there are n judges and m objects to be judged. Each row is a ranking of the objects which are represented by the columns.}

\item{k}{The number of cluster components}

\item{control}{a list of options that control details of the \code{cca} algorithm governed by the function
\code{ccacontrol}. The options govern maximum number of iterations of \code{cca} (itercca=1 is the default), the algorithm chosen to 
compute the median ranking (default, "quick"), and other options related
to the consrank algorithm, which is called by \code{cca}}

\item{\dots}{arguments passed bypassing \code{ccacontrol}}
}
\value{
An object of the class "cca". It contains:
\tabular{lll}{
pk\tab \tab the membership probability matrix\cr
clc\tab \tab  cluster centers\cr
oclc \tab \tab cluster centers in terms of orderings\cr
idc\tab  \tab crisp partition: id of the cluster component associated with the highest membership probability\cr
Hcca  \tab \tab Global homogeneity measure (tau_X rank correlation coefficient) \cr
hk \tab \tab Homogeneity within cluster\cr
props \tab \tab estimated proportion of cases within cluster\cr
Us \tab \tab Uncertainty measure per-individual (see details)\cr
Ucca \tab \tab Global uncertainty measure\cr
Uprods \tab \tab Uncertainty measure per-individual (see details)\cr
Uprodscca \tab \tab Global uncertainty measure\cr
consrankout \tab \tab complete output of rank aggregation algorithm, containing eventually multiple median rankings
}
}
\description{
K-Median Cluster Component Analysis, a distribution-free soft-clustering method
for preference rankings.
}
\details{
The user can use any algorithm implemented in the \code{consrank} function from the \pkg{ConsRank} package. All algorithms allow the user to set the option 'full=TRUE' 
if the median ranking(s) must be searched in the restricted space of permutations instead of in the unconstrained universe of rankings of n items including all possible ties. 
There are two classification uncertainty measures: Us and Uprods. "Us" is the geometric
mean of the membership probabilities of each individual, normalized in such a way that
in the case of maximum uncertainty Us=1. "Ucca" is the average of all the "Us".
"Uprods" is the product of the membership probabilities of each individual, normalized in such a way that
in the case of maximum uncertainty Uprods=1. "Uprodscca" is the average of all the "Uprods".
}
\examples{
\donttest{
data(Irish)
set.seed(135) #for reproducibility
# CCA with four components
ccares <- cca(Irish$rankings, 4, itercca=10)
summary(ccares)
}


}
\references{
D'Ambrosio, A. and Heiser, W.J. (2019). A Distribution-free Soft Clustering Method for Preference Rankings. Behaviormetrika , vol. 46(2), pp. 333–351, DOI: 10.1007/s41237-018-0069-5

Heiser W.J., and D'Ambrosio A. (2013). Clustering and Prediction of Rankings within a Kemeny Distance Framework. 
In Berthold, L., Van den Poel, D, Ultsch, A. (eds). Algorithms from and for Nature and Life.pp-19-31. Springer international. DOI: 10.1007/978-3-319-00035-0_2.

Ben-Israel, A., and Iyigun, C. (2008). Probabilistic d-clustering. Journal of Classification, 25(1), pp.5-26. DOI: 10.1007/s00357-008-9002-z
}
\seealso{
\code{ccacontrol}

\code{ranktree}
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
\keyword{Adjusted}
\keyword{Concordance}
\keyword{Degree}
\keyword{Index}
\keyword{Normalized}
\keyword{Preference}
\keyword{Soft}
\keyword{clustering}
\keyword{of}
\keyword{rankings}
