% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcEMC_wood.R
\name{calcEMC_wood}
\alias{calcEMC_wood}
\title{Calculate Equilibrium Moisture Content for wood (EMC)}
\usage{
calcEMC_wood(Temp, RH)
}
\arguments{
\item{Temp}{Temperature (°Celsius)}

\item{RH}{Relative Humidity (0-100\%)}
}
\value{
EMC, Equilibrium Moisture Content (0-100\%)
}
\description{
This function calculates the Equilibrium Moisture Content (EMC) of wood
based on relative humidity and temperature.

Equilibrium Moisture Content (EMC) is the moisture content at which a material,
such as wood or other hygroscopic substanceshas reached an equilibrium with its
environment and is no longer gaining or losing moisture under specific
temperature and relative humidity.
}
\examples{
calcEMC_wood(20, 50)


# mydata file
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "mydata", n_max = 5)

mydata |> dplyr::mutate(EMC = calcEMC_wood(Temp, RH))


}
\references{
Simpson, W. T. (1998). Equilibrium moisture content of wood in outdoor
locations in the United States and worldwide. Res. Note FPL-RN-0268.
Madison, WI: U.S. Department of Agriculture, Forest Service, Forest
Products Laboratory.

Hailwood, A. J., and Horrobin, S. (1946). Absorption of water by polymers:
Analysis in terms of a simple model.
Transactions of the Faraday Society 42, B084-B092. DOI:10.1039/TF946420B084
}
