% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conMx.R
\name{conMx}
\alias{conMx}
\title{Calculate contingency measure values of a (lagged) time series matrix}
\usage{
conMx(data, data2 = NULL, lag = 0, conFun)
}
\arguments{
\item{data}{Binary time-points-by-variable matrix}

\item{data2}{Second binary time-points-by-variable matrix (optional)}

\item{lag}{Non-negative integer indicating how many time points the second variable is lagged (default 0)}

\item{conFun}{Contingency measure function (calculating the contingency value between two binary vectors).
Built in: funPropAgree, funClassJacc, funKappa, funCorrJacc, funOdds, funLogOdds, funPhiCC}
}
\value{
list with two elements:

\code{value} Matrix of pairwise calculated contingency measures

\code{para}  Parameter settings \code{lag}, \code{funName} and \code{varNames}
}
\description{
Calculate contingency measure values of a (lagged) time series matrix
}
\examples{
conMx(cbind(c(1,0,1,0,1,0,1),c(1,1,1,1,0,0,0)),lag=1,conFun=funCorrJacc)

}
