% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_size_tte.R
\name{samplesize_tte}
\alias{samplesize_tte}
\title{Sample size for composite time to event endpoints}
\usage{
samplesize_tte(
  p0_e1,
  p0_e2,
  HR_e1,
  HR_e2,
  beta_e1 = 1,
  beta_e2 = 1,
  case,
  copula = "Frank",
  rho = 0.3,
  rho_type = "Spearman",
  alpha = 0.05,
  power = 0.8,
  ss_formula = "schoendfeld"
)
}
\arguments{
\item{p0_e1}{numeric parameter between 0 and 1, expected proportion of observed events for the endpoint E1}

\item{p0_e2}{numeric parameter between 0 and 1, expected proportion of observed events for the endpoint E2}

\item{HR_e1}{numeric parameter between 0 and 1, expected cause specific hazard Ratio the endpoint E1}

\item{HR_e2}{numeric parameter between 0 and 1, expected cause specific hazard Ratio the endpoint E2}

\item{beta_e1}{numeric positive parameter, shape parameter (\eqn{\beta_1}) for a Weibull distribution for the endpoint E1 in the control group. See details for more info.}

\item{beta_e2}{numeric positive parameter, shape parameter (\eqn{\beta_2}) for a Weibull distribution for the endpoint E2 in the control group. See details for more info.}

\item{case}{integer parameter in {1,2,3,4}
1: none of the endpoints is death
2: endpoint 2 is death
3: endpoint 1 is death
4: both endpoints are death by different causes}

\item{copula}{character indicating the copula to be used: "Frank" (default), "Gumbel" or "Clayton". See details for more info.}

\item{rho}{numeric parameter between -1 and 1, Spearman's correlation coefficient o Kendall Tau between the marginal distribution of the times to the two events E1 and E2. See details for more info.}

\item{rho_type}{character indicating the type of correlation to be used: "Spearman" (default) or "Tau". See details for more info.}

\item{alpha}{numeric parameter. The probability of type I error. By default \eqn{\alpha=0.05}}

\item{power}{numeric parameter. The power to detect the treatment effect. By default \eqn{1-\beta=0.80}}

\item{ss_formula}{character indicating the formula to be used for the sample size calculation on the single components: 'schoendfeld' (default) or 'freedman'}
}
\value{
A list containing the following components:

\describe{
  \item{\code{ss_E1}}{Total sample size (both groups) for a trial using endpoint 1 as primary endpoint}
  \item{\code{ss_E2}}{Total sample size (both groups) for a trial using endpoint 2 as primary endpoint}
  \item{\code{ss_Ec}}{Total sample size (both groups) for a trial using composite endpoint as primary endpoint}
}
}
\description{
This function calculates the required sample size for trials with a composite time to event endpoint as primary endpoint.
The primary endpoint is assumed to be a composite time to event endpoint formed by a combination of two events (E1 and E2).
The sample size is computed to evaluate differences between two groups based on the log rank test.
The sample size is calculated on the basis of anticipated information on the composite components and the correlation between them.
}
\details{
Some parameters might be difficult to anticipate, especially the shape parameters of Weibull distributions and those referred to the relationship between the marginal distributions. 
For the shape parameters (beta_e1, beta_e2) of the Weibull distribution, we recommend to use \eqn{\beta_j=0.5}, \eqn{\beta_j=1} or \eqn{\beta_j=2} if a decreasing, constant or increasing rates over time are expected, respectively.
For the correlation (rho) between both endpoints, generally a positive value is expected as it has no sense to design an study with two endpoints negatively correlated. We recommend to use \eqn{\rho=0.1}, \eqn{\rho=0.3} or \eqn{\rho=0.5} for weak, mild and moderate correlations, respectively.
For the type of correlation (rho_type), although two different type of correlations are implemented, we recommend the use of the Spearman's correlation.
In any case, if no information is available on these parameters, we recommend to use the default values provided by the function.

The user can choose between the two most common formulae (Schoendfeld and Freedman) for the sample size calculation for the single components. 
Schoendfeld formula always be used for the composite endpoint.
}
\references{
Friedman L.M., Furberg C.D., DeMets D.L. Fundamentals of Clinical Trials. 3rd ed. New York: Springer; 1998.
Cortés Martínez, J., Geskus, R.B., Kim, K. et al. Using the geometric average hazard ratio in sample size calculation for time-to-event data with composite endpoints. BMC Med Res Methodol 21, 99 (2021). https://doi.org/10.1186/s12874-021-01286-x
}
