/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.panel;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import net.infonode.gui.CursorManager;
import net.infonode.gui.panel.BaseContainer;
import net.infonode.util.Direction;

public class ResizablePanel
extends BaseContainer {
    private Direction direction;
    private int resizeWidth = 4;
    private boolean cursorChanged;
    private int offset = -1;
    private boolean mouseInside;
    private boolean heavyWeight = true;
    private boolean continuousLayout = false;
    private Component dragIndicator;
    private JComponent layeredPane;
    private JComponent innerArea;
    private Dimension lastSize;
    private int dragIndicatorThickness = 4;
    private Component comp;

    public ResizablePanel(Direction direction) {
        this(false, direction, null);
    }

    public ResizablePanel(boolean bl, Direction direction, Component component) {
        super(new BorderLayout());
        this.heavyWeight = bl;
        this.direction = direction;
        this.dragIndicator = this.heavyWeight ? new Canvas() : new BaseContainer();
        this.setDragIndicatorColor(null);
        if (component == null) {
            component = this;
        }
        component.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                if (ResizablePanel.this.offset == -1) {
                    ResizablePanel.this.resetCursor();
                }
                ResizablePanel.this.mouseInside = false;
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                ResizablePanel.this.mouseInside = true;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (!ResizablePanel.this.continuousLayout && ResizablePanel.this.layeredPane != null) {
                    if (ResizablePanel.this.layeredPane instanceof JLayeredPane) {
                        ResizablePanel.this.layeredPane.add(ResizablePanel.this.dragIndicator, JLayeredPane.DRAG_LAYER);
                    } else {
                        ResizablePanel.this.layeredPane.add(ResizablePanel.this.dragIndicator, 0);
                    }
                    ResizablePanel.this.layeredPane.repaint();
                    ResizablePanel.this.updateDragIndicator(mouseEvent);
                }
                if (ResizablePanel.this.cursorChanged) {
                    ResizablePanel.this.offset = ResizablePanel.this.direction == Direction.LEFT ? mouseEvent.getPoint().x : (ResizablePanel.this.direction == Direction.RIGHT ? ResizablePanel.this.getWidth() - mouseEvent.getPoint().x : (ResizablePanel.this.direction == Direction.UP ? mouseEvent.getPoint().y : ResizablePanel.this.getHeight() - mouseEvent.getPoint().y));
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (!ResizablePanel.this.continuousLayout && ResizablePanel.this.layeredPane != null) {
                    ResizablePanel.this.layeredPane.remove(ResizablePanel.this.dragIndicator);
                    ResizablePanel.this.layeredPane.repaint();
                }
                ResizablePanel.this.offset = -1;
                ResizablePanel.this.checkCursor(mouseEvent.getPoint());
                if (!ResizablePanel.this.continuousLayout && ResizablePanel.this.lastSize != null) {
                    ResizablePanel.this.setPreferredSize(ResizablePanel.this.lastSize);
                    ResizablePanel.this.revalidate();
                }
                ResizablePanel.this.lastSize = null;
            }
        });
        component.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                ResizablePanel.this.checkCursor(mouseEvent.getPoint());
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (ResizablePanel.this.offset != -1) {
                    int n = ResizablePanel.this.direction.isHorizontal() ? (ResizablePanel.this.direction == Direction.LEFT ? ResizablePanel.this.getWidth() - mouseEvent.getPoint().x + ResizablePanel.this.offset : mouseEvent.getPoint().x + ResizablePanel.this.offset) : (ResizablePanel.this.direction == Direction.UP ? ResizablePanel.this.getHeight() - mouseEvent.getPoint().y + ResizablePanel.this.offset : mouseEvent.getPoint().y + ResizablePanel.this.offset);
                    ResizablePanel.this.lastSize = ResizablePanel.this.getBoundedSize(n);
                    if (ResizablePanel.this.continuousLayout) {
                        ResizablePanel.this.setPreferredSize(ResizablePanel.this.lastSize);
                        ResizablePanel.this.revalidate();
                    } else {
                        ResizablePanel.this.updateDragIndicator(mouseEvent);
                    }
                }
            }
        });
    }

    public void setComponent(Component component) {
        if (this.comp != null) {
            this.remove(this.comp);
        }
        if (component != null) {
            this.add(component, "Center");
            this.revalidate();
        }
        this.comp = component;
    }

    public void setDragIndicatorColor(Color color) {
        this.dragIndicator.setBackground(color == null ? Color.DARK_GRAY : color);
    }

    public void setLayeredPane(JComponent jComponent) {
        this.layeredPane = jComponent;
        if (this.innerArea == null) {
            this.innerArea = jComponent;
        }
    }

    public void setInnerArea(JComponent jComponent) {
        if (jComponent == null) {
            jComponent = this.layeredPane;
        } else {
            this.innerArea = jComponent;
        }
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public void setContinuousLayout(boolean bl) {
        this.continuousLayout = bl;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return this.getBoundedSize(this.direction.isHorizontal() ? dimension.width : dimension.height);
    }

    private void updateDragIndicator(MouseEvent mouseEvent) {
        if (this.layeredPane != null) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this.layeredPane);
            Point point2 = SwingUtilities.convertPoint(this.getParent(), this.getLocation(), this.layeredPane);
            Dimension dimension = this.innerArea.getSize();
            Dimension dimension2 = this.getMinimumSize();
            Point point3 = SwingUtilities.convertPoint(this.innerArea, 0, 0, this.layeredPane);
            if (this.direction.isHorizontal()) {
                int n = 0;
                n = this.direction == Direction.LEFT ? Math.min(Math.max(point3.x, point.x), point3.x + dimension.width - dimension2.width) : Math.min(Math.max(point3.x + dimension2.width, point.x), point3.x + dimension.width) - this.dragIndicatorThickness;
                this.dragIndicator.setBounds(n, point2.y, this.dragIndicatorThickness, this.getHeight());
            } else {
                int n = 0;
                n = this.direction == Direction.UP ? Math.min(Math.max(point3.y, point.y), point3.y + dimension.height - dimension2.height) : Math.min(Math.max(point3.y + dimension2.height, point.y), point3.y + dimension.height) - this.dragIndicatorThickness;
                this.dragIndicator.setBounds(point2.x, n, this.getWidth(), this.dragIndicatorThickness);
            }
        }
    }

    private Dimension getBoundedSize(int n) {
        if (this.direction.isHorizontal()) {
            return new Dimension(Math.max(this.getMinimumSize().width, Math.min(n, this.getMaximumSize().width)), 0);
        }
        return new Dimension(0, Math.max(this.getMinimumSize().height, Math.min(n, this.getMaximumSize().height)));
    }

    public void setResizeWidth(int n) {
        this.resizeWidth = n;
    }

    public int getResizeWidth() {
        return this.resizeWidth;
    }

    private void checkCursor(Point point) {
        int n;
        if (this.offset != -1) {
            return;
        }
        int n2 = this.direction == Direction.UP ? point.y : (this.direction == Direction.DOWN ? this.getHeight() - point.y : (n = this.direction == Direction.LEFT ? point.x : this.getWidth() - point.x));
        if (n >= 0 && n < this.resizeWidth && this.mouseInside) {
            if (!this.cursorChanged) {
                this.cursorChanged = true;
                CursorManager.setGlobalCursor(this.getRootPane(), new Cursor(this.direction == Direction.LEFT ? 10 : (this.direction == Direction.RIGHT ? 11 : (this.direction == Direction.UP ? 8 : 9))));
            }
        } else {
            this.resetCursor();
        }
    }

    private void resetCursor() {
        CursorManager.resetGlobalCursor(this.getRootPane());
        this.cursorChanged = false;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }
}

