% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Poisson_Regression.R
\name{RunPoissonRegression_Joint_Omnibus}
\alias{RunPoissonRegression_Joint_Omnibus}
\title{Performs joint Poisson regression using the omnibus function}
\usage{
RunPoissonRegression_Joint_Omnibus(
  df,
  pyr0,
  events,
  name_list,
  term_n_list = list(),
  tform_list = list(),
  keep_constant_list = list(),
  a_n_list = list(),
  modelform = "M",
  fir = 0,
  der_iden = 0,
  control = list(),
  strat_col = "null",
  model_control = list(),
  cons_mat = as.matrix(c(0)),
  cons_vec = c(0)
)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{pyr0}{column used for person-years per row}

\item{events}{vector of event column names}

\item{name_list}{list of vectors for columns for event specific or shared model elements, required}

\item{term_n_list}{list of vectors for term numbers for event specific or shared model elements, defaults to term 0}

\item{tform_list}{list of vectors for subterm types for event specific or shared model elements, defaults to loglinear}

\item{keep_constant_list}{list of vectors for constant elements for event specific or shared model elements, defaults to free (0)}

\item{a_n_list}{list of vectors for parameter values for event specific or shared model elements, defaults to term 0}

\item{modelform}{string specifying the model type: M, ME, A, PA, PAE, GMIX, GMIX-R, GMIX-E}

\item{fir}{term number for the initial term, used for models of the form T0*f(Ti) in which the order matters}

\item{der_iden}{number for the subterm to test derivative at, only used for testing runs with a single varying parameter, should be smaller than total number of parameters. indexed starting at 0}

\item{control}{list of parameters controlling the convergence, see Def_Control() for options or vignette("Control_Options")}

\item{strat_col}{column to stratify by if needed}

\item{model_control}{controls which alternative model options are used, see Def_model_control() for options and vignette("Control_Options") for further details}

\item{cons_mat}{Matrix containing coefficients for system of linear constraints, formatted as matrix}

\item{cons_vec}{Vector containing constants for system of linear constraints, formatted as vector}
}
\value{
returns a list of the final results
}
\description{
\code{RunPoissonRegression_Joint_Omnibus} uses user provided data, time/event columns,
vectors specifying the model, and options to control the convergence and starting positions.
Has additional options to starting with several initial guesses, uses joint competing risks equation
}
\examples{
library(data.table)
## basic example code reproduced from the starting-description vignette

a <- c(0,0,0,1,1,1)
b <- c(1,1,1,2,2,2)
c <- c(0,1,2,2,1,0)
d <- c(1,1,0,0,1,1)
e <- c(0,1,1,1,0,0)
f <- c(0,1,0,0,1,1)
df <- data.table('t0'=a,'t1'=b,'e0'=c,'e1'=d,'fac'=e)
time1 <- "t0"
time2 <- "t1"
df$pyr <- df$t1 - df$t0
pyr <- "pyr"
events <- c('e0','e1')
names_e0 <- c('fac')
names_e1 <- c('fac')
names_shared <- c('t0','t0')
term_n_e0 <- c(0)
term_n_e1 <- c(0)
term_n_shared <- c(0,0)
tform_e0 <- c("loglin")
tform_e1 <- c("loglin")
tform_shared <- c("quad_slope","loglin_top")
keep_constant_e0 <- c(0)
keep_constant_e1 <- c(0)
keep_constant_shared <- c(0,0)
a_n_e0 <- c(-0.1)
a_n_e1 <- c(0.1)
a_n_shared <- c(0.001, -0.02)
name_list <- list('shared'=names_shared,'e0'=names_e0,'e1'=names_e1)
term_n_list <- list('shared'=term_n_shared,'e0'=term_n_e0,'e1'=term_n_e1)
tform_list <- list('shared'=tform_shared,'e0'=tform_e0,'e1'=tform_e1)
keep_constant_list <- list('shared'=keep_constant_shared,
                           'e0'=keep_constant_e0,'e1'=keep_constant_e1)
a_n_list <- list('shared'=a_n_shared,'e0'=a_n_e0,'e1'=a_n_e1)

der_iden <- 0
modelform <- "M"
fir <- 0
control <- list("ncores"=2,'lr' = 0.75,'maxiter' = 5,'halfmax' = 5,'epsilon' = 1e-3,
   'deriv_epsilon' = 1e-3, 'abs_max'=1.0,'change_all'=TRUE,
   'dose_abs_max'=100.0,'verbose'=FALSE, 'ties'='breslow','double_step'=1)
guesses_control <- list("maxiter"=10,"guesses"=10,"lin_min"=0.001,"lin_max"=1,
    "loglin_min"=-1,"loglin_max"=1, "lin_method"="uniform","loglin_method"="uniform",
     strata=FALSE)
strat_col <- 'f'
e <- RunPoissonRegression_Joint_Omnibus(df, pyr, events, name_list, term_n_list,
                                        tform_list, keep_constant_list, a_n_list,
                                        modelform, fir, der_iden, control,strat_col)

}
\seealso{
Other Poisson Wrapper Functions: 
\code{\link{RunPoissonEventAssignment}()},
\code{\link{RunPoissonEventAssignment_bound}()},
\code{\link{RunPoissonRegression}()},
\code{\link{RunPoissonRegression_Guesses_CPP}()},
\code{\link{RunPoissonRegression_Omnibus}()},
\code{\link{RunPoissonRegression_Residual}()},
\code{\link{RunPoissonRegression_STRATA}()},
\code{\link{RunPoissonRegression_Single}()},
\code{\link{RunPoissonRegression_Tier_Guesses}()}
}
\concept{Poisson Wrapper Functions}
