% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_glm2.R
\name{changeByMap}
\alias{changeByMap}
\title{Transform a vector by a mapping}
\usage{
changeByMap(old_vector, mapping_dat, reverse = FALSE)
}
\arguments{
\item{old_vector}{vector of any type.}

\item{mapping_dat}{data.frame, first column must be the same type as the \code{old_vector}}

\item{reverse}{logical. Reverse domain and range if set to TRUE}
}
\value{
The new vector (mapped from the old one).
}
\description{
The mapping is represented by a data.frame:
1st column is the domain, 2st column is the range.
}
\examples{
\dontrun{
names_dat = data.frame(c("a", "b", "c"), c("d", "e", "f"), stringsAsFactors=FALSE)
changeByMap(c("a", "a", "b"), names_dat) == c("d", "d", "e")
x = changeByMap(c(NA, "a", "b"), names_dat)
is.na(x[1])
}
}
\author{
Kaiyin Zhong, Fan Liu
}

