% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{splitNameLevel}
\alias{splitNameLevel}
\title{Split name and level columns into the columns.}
\usage{
splitNameLevel(
  result,
  name = "group_name",
  level = "group_level",
  keep = FALSE,
  overall = FALSE
)
}
\arguments{
\item{result}{Omop result object (summarised_result or compared_result).}

\item{name}{Column with the names.}

\item{level}{Column with the levels.}

\item{keep}{Whether to keep the original group_name and group_level columns.}

\item{overall}{Whether to keep overall column if present.}
}
\value{
A dataframe with the specified name column values as columns.
}
\description{
Pivots the input dataframe so the values of the name columns are tranformed
into columns, which values come from the specified level column.
}
\examples{
x <- dplyr::tibble(
  variable = "number subjects",
  value = c(10, 15, 40, 78),
  group_name = c("sex and age_group", "sex and age_group",
  "sex and age_group", "sex and age_group"),
  group_level = c("Male and <40", "Female and >40", "Male and >40", "Male and <40")
)
  x \%>\% splitNameLevel(name = "group_name",
                 level = "group_level",
                 keep = FALSE)

}
