% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_trial.R
\name{plot_trial}
\alias{plot_trial}
\title{Plots the cohort trial study overview given stage data.}
\usage{
plot_trial(res_list, unit = "cohort")
}
\arguments{
\item{res_list}{List item containing trial results so far in a format used by the other functions in this package}

\item{unit}{What is unit of observation in response rate plots: N_cohort or N_total?}
}
\description{
Given a res_list object, plots things like final study design, indicating which arms were discontinued after how many patients etc..
}
\examples{

random <- TRUE

rr_comb <- c(1)
prob_comb_rr <- c(1)
rr_mono <- c(1,2)
prob_mono_rr <- c(0.2, 0.8)
rr_back <- c(2)
prob_back_rr <- c(1)
rr_plac <- c(0.10)
prob_plac_rr <- c(1)

rr_transform <- list(
  function(x) {return(c(0.90*(1 - x), (1-0.90)*(1-x), (1-0.90)*x, 0.90*x))}
)
prob_rr_transform <- c(1)

cohorts_max <- 20
trial_struc <- "all_plac"
safety_prob <- 0
sharing_type <- "dynamic"
sr_drugs_pos <- 7
n_int <- 100
n_fin <- 200
stage_data <- TRUE
cohort_random <- 0.02
target_rr <- c(0,0,1)
cohort_offset <- 0
random_type <- "risk_ratio"
sr_first_pos <- FALSE

# Vergleich Combo vs Mono
Bayes_Sup1 <- matrix(nrow = 1, ncol = 3)
Bayes_Sup1[1,] <- c(0.00, 0.90, 1.00)
# Vergleich Combo vs Backbone
Bayes_Sup2 <- matrix(nrow = 1, ncol = 3)
Bayes_Sup2[1,] <- c(0.00, 0.90, 1.00)
# Vergleich Mono vs Placebo
Bayes_Sup3 <- matrix(nrow = 1, ncol = 3)
Bayes_Sup3[1,] <- c(0.00, 0.80, 1.00)
Bayes_Sup4 <- matrix(nrow = 1, ncol = 3)
Bayes_Sup4[1,] <- c(0.00, 0.80, 1.00)
Bayes_Sup <- list(list(Bayes_Sup1, Bayes_Sup2, Bayes_Sup3, Bayes_Sup4),
             list(Bayes_Sup1, Bayes_Sup2, Bayes_Sup3, Bayes_Sup4))

# Vergleich Combo vs Mono
Bayes_Fut1 <- matrix(nrow = 1, ncol = 2)
Bayes_Fut1[1,] <- c(0.00, 0.50)
# Vergleich Combo vs Backbone
Bayes_Fut2 <- matrix(nrow = 1, ncol = 2)
Bayes_Fut2[1,] <- c(0.00, 0.50)
# Vergleich Mono vs Placebo
Bayes_Fut3 <- matrix(nrow = 1, ncol = 2)
Bayes_Fut3[1,] <- c(0.00, 0.50)
Bayes_Fut4 <- matrix(nrow = 1, ncol = 2)
Bayes_Fut4[1,] <- c(0.00, 0.50)
Bayes_Fut <- list(list(Bayes_Fut1, Bayes_Fut2, Bayes_Fut3, Bayes_Fut4),
                  list(Bayes_Fut1, Bayes_Fut2, Bayes_Fut3, Bayes_Fut4))

res_list <- simulate_trial(
n_int = n_int, n_fin = n_fin, trial_struc = trial_struc, random_type = random_type,
rr_comb = rr_comb, rr_mono = rr_mono, rr_back = rr_back, rr_plac = rr_plac,
rr_transform = rr_transform, random = random, prob_comb_rr = prob_comb_rr,
prob_mono_rr = prob_mono_rr, prob_back_rr = prob_back_rr, prob_plac_rr = prob_plac_rr,
stage_data = stage_data, cohort_random = cohort_random, cohorts_max = cohorts_max,
sr_drugs_pos = sr_drugs_pos, target_rr = target_rr, sharing_type = sharing_type,
safety_prob = safety_prob, Bayes_Sup = Bayes_Sup, prob_rr_transform = prob_rr_transform,
cohort_offset = cohort_offset, Bayes_Fut = Bayes_Fut, sr_first_pos = sr_first_pos
)

plot_trial(res_list, unit = "n")

}
