% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchCohorts.R
\name{matchCohorts}
\alias{matchCohorts}
\title{Generate a new cohort matched cohort}
\usage{
matchCohorts(
  cohort,
  cohortId = NULL,
  matchSex = TRUE,
  matchYearOfBirth = TRUE,
  ratio = 1,
  keepOriginalCohorts = FALSE,
  name = tableName(cohort),
  .softValidation = FALSE
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{Vector identifying which cohorts to include
(cohort_definition_id or cohort_name). Cohorts not included will be
removed from the cohort set.}

\item{matchSex}{Whether to match in sex.}

\item{matchYearOfBirth}{Whether to match in year of birth.}

\item{ratio}{Number of allowed matches per individual in the target cohort.}

\item{keepOriginalCohorts}{If TRUE the original cohorts will be return
together with the new ones. If FALSE only the new cohort will be returned.}

\item{name}{Name of the new cohort table created in the cdm object.}

\item{.softValidation}{Whether to perform a soft validation of consistency.
If set to FALSE four additional checks will be performed: 1) a check that
cohort end date is not before cohort start date,  2) a check that there
are no missing values in required columns, 3) a check that cohort duration is
all within observation period, and 4) that there are no overlapping
cohort entries}
}
\value{
A cohort table.
}
\description{
\code{matchCohorts()} generate a new cohort matched to individuals in an
existing cohort. Individuals can be matched based on year of birth and sex.
Matching is done at the record level, so if individuals have multiple
cohort entries they can be matched to different individuals for each of their
records.

Two new cohorts will be created when matching. The first is those
cohort entries which were matched ("_sampled" is added to the original
cohort name for this cohort). The other is the matches found from the
database population ("_matched" is added to the original cohort name
for this cohort).
}
\examples{
\donttest{
library(CohortConstructor)
library(dplyr)
cdm <- mockCohortConstructor(nPerson = 200)
cdm$new_matched_cohort <- cdm$cohort2 |>
  matchCohorts(
    name = "new_matched_cohort",
    cohortId = 2,
    matchSex = TRUE,
    matchYearOfBirth = TRUE,
    ratio = 1)
cdm$new_matched_cohort
}
}
