% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requireCohortIntersectFlag.R
\name{requireCohortIntersect}
\alias{requireCohortIntersect}
\title{Require cohort subjects are present (or absence) in another cohort}
\usage{
requireCohortIntersect(
  cohort,
  targetCohortTable,
  window,
  intersections = c(1, Inf),
  cohortId = NULL,
  targetCohortId = NULL,
  indexDate = "cohort_start_date",
  targetStartDate = "cohort_start_date",
  targetEndDate = "cohort_end_date",
  censorDate = NULL,
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{targetCohortTable}{Name of the cohort that we want to check for
intersect.}

\item{window}{Window to consider events over.}

\item{intersections}{A range indicating number of intersections for
criteria to be fulfilled. If a single number is passed, the number of
intersections must match this.}

\item{cohortId}{IDs of the cohorts to modify. If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{targetCohortId}{Vector of cohort definition ids to include.}

\item{indexDate}{Variable in x that contains the date to compute the
intersection.}

\item{targetStartDate}{Date of reference in cohort table, either for start
(in overlap) or on its own (for incidence).}

\item{targetEndDate}{Date of reference in cohort table, either for end
(overlap) or NULL (if incidence).}

\item{censorDate}{Whether to censor overlap events at a specific date or a
column date of x.}

\item{name}{Name of the new cohort with the future observation restriction.}
}
\value{
Cohort table with only those isatisfying the criteria kept
}
\description{
\code{requireCohortIntersect()} filters a cohort table based on a requirement
that an individual is seen (or not seen) in another cohort in some time
window around an index date.
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor()
cdm$cohort1 |>
  requireCohortIntersect(targetCohortTable = "cohort2",
                             targetCohortId = 1,
                             indexDate = "cohort_start_date",
                             window = c(-Inf, 0))
}
}
