% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requireTableIntersectFlag.R
\name{requireTableIntersectFlag}
\alias{requireTableIntersectFlag}
\title{Require cohort subjects are present in another table}
\usage{
requireTableIntersectFlag(
  cohort,
  tableName,
  window,
  cohortId = NULL,
  indexDate = "cohort_start_date",
  targetStartDate = startDateColumn(tableName),
  targetEndDate = endDateColumn(tableName),
  censorDate = NULL,
  negate = FALSE,
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{tableName}{Name of the table to check for intersect.}

\item{window}{Window to consider events over.}

\item{cohortId}{IDs of the cohorts to modify. If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{indexDate}{Variable in x that contains the date to compute the
intersection.}

\item{targetStartDate}{Date of reference in cohort table, either for start
(in overlap) or on its own (for incidence).}

\item{targetEndDate}{Date of reference in cohort table, either for end
(overlap) or NULL (if incidence).}

\item{censorDate}{Whether to censor overlap events at a specific date or a
column date of x.}

\item{negate}{If set as TRUE, criteria will be applied as exclusion
rather than inclusion (i.e. require absence in another cohort).}

\item{name}{Name of the new cohort with the future observation restriction.}
}
\value{
Cohort table with only those in the other table kept (or those that
are not in the table if negate = TRUE)
}
\description{
Require cohort subjects are present in another table
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor(drugExposure = TRUE)
cdm$cohort1 |>
  requireTableIntersectFlag(tableName = "drug_exposure",
                            indexDate = "cohort_start_date",
                            window = c(-Inf, 0))
}
}
