% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypergeometrics.R
\name{hypergeometrics}
\alias{hypergeometrics}
\alias{hypergeometric0F1}
\alias{hypergeometric1F1}
\alias{hypergeometric2F1}
\title{hypergeometric functions.}
\usage{
hypergeometric0F1(a, z)      
hypergeometric1F1(a, b, z)  
hypergeometric2F1(a, b, c, z)
}
\arguments{
\item{a}{the first parameter;}

\item{z}{the argument raised to the powers 0 ... infinity ;}

\item{b}{the second parameter;}

\item{c}{the third parameter;}
}
\value{
\preformatted{The result of the hypergeometric function.
}
}
\description{
The hypergeometric functions are a series of functions which includes
the hypergeometric0F1, called the confluent hypergeometric limit function (D. Cousineau);
the hypergeometric1F1, called the confluent hypergeometric function \insertCite{m14}{CohensdpLibrary};
and the hypergeometric2F1, called Gauss' confluent hypergeometric function \insertCite{MICHEL2008535}{CohensdpLibrary}.
These functions are involved in the computation of the K' and Lambda'
distributions, as well as the Chi-square" and the t" distributions
\insertCite{c22a}{CohensdpLibrary}.
}
\examples{

hypergeometric0F1(12, 0.4)         #   1.033851
hypergeometric1F1(12, 14, 0.4)     #   1.409877
hypergeometric2F1(12, 14, 16, 0.4) # 205.5699

}
\references{
\insertAllCited{}
}
