% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableUnmappedCodes.R
\name{tableUnmappedCodes}
\alias{tableUnmappedCodes}
\title{Format the result of summariseUnmappedCodeUse into a table.}
\usage{
tableUnmappedCodes(
  result,
  type = "gt",
  header = c("cdm_name", "estimate_name"),
  groupColumn = character(),
  hide = character(),
  .options = list()
)
}
\arguments{
\item{result}{A \verb{<summarised_result>} with results of the type
"umapped_codes".}

\item{type}{Type of desired formatted table. To see supported formats
use visOmopResults::tableType()}

\item{header}{A vector specifying the elements to include in the header. The
order of elements matters, with the first being the topmost header.
The header vector can contain one of the following variables: "cdm_name",
"codelist_name", "domain_id", "standard_concept_name", "standard_concept_id",
"estimate_name", "standard_concept", "vocabulary_id".
Alternatively, it can include other names to use as overall header labels.}

\item{groupColumn}{Variables to use as group labels. Allowed columns are:
"cdm_name", "codelist_name", "domain_id", "standard_concept_name",
"standard_concept_id", "estimate_name", "standard_concept", "vocabulary_id".
These cannot be used in header.}

\item{hide}{Table columns to exclude, options are:  "cdm_name",
"codelist_name", "domain_id", "standard_concept_name", "standard_concept_id",
"estimate_name", "standard_concept", "vocabulary_id". These cannot be used in
header or groupColumn.}

\item{.options}{Named list with additional formatting options.
visOmopResults::tableOptions() shows allowed arguments and
their default values.}
}
\value{
A table with a formatted version of the summariseUnmappedCodes
result.
}
\description{
Format the result of summariseUnmappedCodeUse into a table.
}
