% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vocabUtilities.R
\name{getRelationshipId}
\alias{getRelationshipId}
\title{Get relationship ID values from the concept relationship table}
\usage{
getRelationshipId(
  cdm,
  standardConcept1 = "standard",
  standardConcept2 = "standard",
  domains1 = "condition",
  domains2 = "condition"
)
}
\arguments{
\item{cdm}{A cdm reference}

\item{standardConcept1}{Character vector with one or more of "Standard",
"Classification", and "Non-standard". These correspond to the flags used
for the standard_concept field in the concept table of the cdm.}

\item{standardConcept2}{Character vector with one or more of "Standard",
"Classification", and "Non-standard". These correspond to the flags used
for the standard_concept field in the concept table of the cdm.}

\item{domains1}{Character vector with one or more of the OMOP CDM domain.}

\item{domains2}{Character vector with one or more of the OMOP CDM domain.}
}
\value{
A character vector with unique values
}
\description{
Get relationship ID values from the concept relationship table
}
\examples{
\donttest{
cdm <- mockVocabRef()
getRelationshipId(cdm = cdm)
}
}
