\name{inputCollector}
\alias{inputCollector}
\title{
Create customized input/output collector for use in getInputs
}
\description{
Create a custom input collector which will be used by getInputs to
process
to collect various aspects of the code as it is being processed. Custom
collector functions can be specified which will be called when a
particular function is called within the code.One major use for this is
leveraging knowledge of specific functions' behavior to track side
effects relevant to a particular use-case.
}
\usage{
inputCollector(..., functionHandlers = list(...), inclPrevOutput =
FALSE, checkLibrarySymbols = FALSE, funcsAsInputs = checkLibrarySymbols)
}
\arguments{
  \item{\dots}{
    Custom information collection functions. Argument names correspond to
    R functions, with the custom collection function being called when a
    call to the named function is detected within the code being
    processed. Overridden by \code{functionHandlers}
  }
  \item{functionHandlers}{
    A named list of custom collection functions. 
  }
  \item{inclPrevOutput}{Should variables which were output previously
    within the code be treated as inputs in subsequent expressions. If
    \code{TRUE} each expression within the code is treated separately
    with respect to detecting input variables, if \code{FALSE} the code
    is treated as a single block. Defaults to \code{FALSE}
  }
  \item{checkLibrarySymbols}{If \code{TRUE} symbols exported by default
    package and packages loaded within the code via \code{library} or
    \code{require} calls are tracked and excluded from the list of input
    variables. Defaults to\code{FALSE}
  }
  \item{funcsAsInputs}{If \code{TRUE} functions called by the code being
    processed are treated as input variables and listed as
    such. Defaults to the value of \code{checkLibrarySymbols}. A value
    of \code{funcsAsInputs} which does not agree with the value of
    \code{checkLibrarySymbols} is NOT recommended.
  }
}
\details{
  Each custom collection function should accept three arguments:
  \describe{
    \item{e: }{the code or expression currently being processed}
    \item{collector: }{the current inputCollector}
    \item{basedir: }{the base directory in which the processing is taking place, e.g. to determine whether strings correspond to files}
  }
  
  These functions should process the expression and then use
  \code{collector}'s collection functions and/or the \code{<<-}
  assignment operator to update the lists of found entities.
  
  Currently trackable entities, updatable by \verb{<entity><<-c(<entity>,
    value)} or as specified, include:
  \describe{
    \item{libraries: }{libraries loaded by the code via \code{library} or
      \code{require}. Updatable by calling \code{collector$library}
    }
    \item{libSymbols: }{symbols exported by available libraries. Tracked
      automatically within \code{collector$library}
    }
    \item{files: }{string constants which correspond to an existing file in
      \code{basedir}. Tracked automatically when strings are passed to
      \code{collector$string}
    }
    \item{strings: }{string constants which do not correspond to existing
      files. Tracked automatically when strings are passed to
      \code{collector$string}
    }
    \item{vars: }{all variable names used in the code. Updatable by calling
      \code{collector$vars} with \code{input} as \code{TRUE} or \code{FALSE}
      as appropriate}
    \item{set: }{variable names which are assigned to in the code (input
      variables). Updatable by calling \code{collector$set} or
      \code{collector$vars} with \code{input=TRUE}
    }
    \item{functions: }{functions called by the code. Updatable by calling
      \code{collector$calls}. This will also update \code{vars} if the
      collector was created with \code{funcsAsInputs=TRUE}
    }
    \item{removes: }{variables removed by the vode via calls to
      \code{collector$removes}
    }
    \item{updates: }{variables which have had elements within them updated,
      e.g. via \code{x$foo <- bar}. Updatable via calls to
      \code{collector$update}
    }
    \item{sideEffects: }{side effects generated by the code. Experimental,
      default side effect detection should not be assumed to be robust or
      exhaustive. Updatable via calls to \code{sideEffects}
    }
    \item{formulaVariables: }{If \code{formulaInputs} is \code{FALSE} within
      the call to getInputs, this tracks variables which appear within
      formulas, otherwise this is unused and such variables are treated as
      input. Updatable via the modelVars argument in calls to
      \code{collector$addInfo}
    }
  }
}
\value{
  A list of functions used to update internal tracking variables (see
  Details) as well as the following:
  \describe{
    \item{functionHandlers: }{The list of function handlers in use by the
      collector.}
    \item{reset: }{A function which resets the internal tracking variables.}
    \item{results: }{A function which returns a
      \code{\linkS4class{ScriptNodeInfo}} object representing the current state of
      the collection.}
  }
}
\author{
  Duncan Temple Lang
}
\note{
  Custom handlers take precedence over default proccessing
  mechanism. Care should be taken when overriding core functions such as
  \code{=}, \code{~}, \code{$}, \code{library}, etc.
}
\note{
  Specific internal behaviors of the default collection mechanisms are
  experimental and may change in future versions.
}
\seealso{
  \code{\linkS4class{ScriptNodeInfo}} \code{\link{getInputs}}
}
\examples{
   f = system.file("samples", "results-multi.R", package="CodeDepends")
   sc = readScript(f)
  collector = inputCollector(library = function(e, collector, basedir, ...)
  {
    print(paste("loaded library",  e[[2]]))
    collector$library(as.character(e[[2]]))
})
  res = getInputs(sc, collector = collector )
  #[1] "loaded library splines"
  #[1] "loaded library tsModel"
}
\keyword{ programming }
\keyword{ code }
\keyword{ analysis }
\keyword{ static }
