% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctmaLCS.R
\name{ctmaLCS}
\alias{ctmaLCS}
\title{ctmaLCS}
\usage{
ctmaLCS(
  CoTiMAFit = NULL,
  undoTimeScaling = TRUE,
  digits = 4,
  activateRPB = FALSE
)
}
\arguments{
\item{CoTiMAFit}{Fitted CoTiMA object.}

\item{undoTimeScaling}{Whether (TRUE) or not (FALSE) LCS results should be provided ignoring the scaleTime argument used in ctmaFit.}

\item{digits}{Number of digits used for rounding (in outputs)}

\item{activateRPB}{set to TRUE to receive push messages with 'CoTiMA' notifications on your phone}
}
\value{
Returns LCS effects derived from CT CoTiMA CLPM estimates.
}
\description{
Transforms estimates obtained with \code{\link{ctmaFit}} into LCS (latent change score) terminology.
LCS models can be estimated with CT CLPM, but results have to be transformed. When time intervals vary much
between and within persons, LCS models are virtually impossible to fit. However, CT CLPM models can be
fitted, and the results - after transformation - show what LCS estimates would have been (cf Voelke & Oud,
2015; their terminology to label LCS effects is used in the output created by ctmaLCS)
}
\examples{
\dontrun{
LCSresults <- ctmaLCS(CoTiMAFullFit_6)
}

}
