% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateRFFast.r
\name{generateRFFast}
\alias{generateRFFast}
\title{Faster simulation of random fields with approximately separable spatiotemporal correlation structure}
\usage{
generateRFFast(
  n,
  spacepoints,
  margdist,
  margarg,
  p0,
  distbounds = c(-Inf, Inf),
  stcsid,
  stcsarg,
  scalefactor = 1,
  anisotropyarg = list(phi1 = 1, phi2 = 1, theta = 0)
)
}
\arguments{
\item{n}{number of fields (time steps) to simulate}

\item{spacepoints}{side length m of the square field (m x m)}

\item{margdist}{target marginal distribution of the field}

\item{margarg}{list of marginal distribution arguments}

\item{p0}{probability zero}

\item{distbounds}{distribution bounds (default set to c(-Inf, Inf))}

\item{stcsid}{spatiotemporal correlation structure ID}

\item{stcsarg}{list of spatiotemporal correlation structure arguments}

\item{scalefactor}{factor specifying the distance between the centers of two pixels (default set to 1)}

\item{anisotropyarg}{list of arguments establishing spatial anisotropy. phi1 and phi2 control the stretch in two orthogonal directions (e.g., longitude and latitude) while the angle theta controls a counterclockwise rotation (default set to list(phi1 = 1, phi2 = 1 , theta = 0) for isotropic fields)}
}
\description{
For more details see section 6 in \href{https://doi.org/10.1029/2018WR023055}{Serinaldi and Kilsby (2018)}, and section 2.4 in \href{https://doi.org/10.1029/2019WR026331}{Papalexiou and Serinaldi (2020)}
}
\details{
\code{\link{generateRFFast}} provides a faster approach to RF simulation
compared to \code{\link{generateRF}} by exploiting circulant embedding
fast Fourier transformation.
However, this approach is feasible only for approximately
separable target spatiotemporal correlation functions (see section 6 in
\href{https://doi.org/10.1029/2018WR023055}{Serinaldi and Kilsby (2018)}).
\code{\link{generateRFFast}} comprises fitting and simulation in a single function.
Here, we give indicative CPU times for some settings, referring to a
Windows 10 Pro x64 laptop with Intel(R) Core(TM) i7-6700HQ CPU @ 2.60GHz,
4-core, 8 logical processors, and 32GB RAM. \cr
CPU time:\cr
m = 50, n = 1000: ~58s \cr
m = 50, n = 10000: ~160s \cr
m = 100, n = 1000: ~2955s (~50min) \cr
}
\examples{

sim <- generateRFFast(
    n = 50,
    spacepoints = 3,
    p0 = 0.7,
    margdist ='paretoII',
    margarg = list(scale = 1,
                   shape = .3),
    stcsarg = list(scfid = "weibull",
                   tcfid = "weibull",
                   scfarg = list(scale = 20,
                                 shape = 0.7),
                   tcfarg = list(scale = 1.1,
                                 shape = 0.8))
)

checkRF(sim,
          lags = 10,
          nfields = 49)

}
