% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitVAR.r
\name{fitVAR}
\alias{fitVAR}
\title{VAR model parameters to simulate correlated parent Gaussian random vectors and fields}
\usage{
fitVAR(
  spacepoints,
  p,
  margdist,
  margarg,
  p0,
  distbounds = c(-Inf, Inf),
  stcsid,
  stcsarg,
  scalefactor = 1,
  anisotropyarg = list(phi1 = 1, phi2 = 1, theta = 0)
)
}
\arguments{
\item{spacepoints}{it can be a numeric integer, which is interpreted as the side length m of the square field (m x m), or a matrix (d x 2) of coordinates (e.g. longitude and latitude) of d spatial locations (e.g. d gauge stations)}

\item{p}{order of VAR(p) model}

\item{margdist}{target marginal distribution of the field}

\item{margarg}{list of marginal distribution arguments. Please consult the documentation of the selected marginal distribution indicated in the argument “margdist” for the list of required parameters}

\item{p0}{probability zero}

\item{distbounds}{distribution bounds (default set to c(-Inf, Inf))}

\item{stcsid}{spatiotemporal correlation structure ID}

\item{stcsarg}{list of spatiotemporal correlation structure arguments. Please consult the documentation of the selected spatiotemporal correlation structure indicated in the argument “stcsid” for the list of required parameters}

\item{scalefactor}{factor specifying the distance between the centers of two pixels (default set to 1)}

\item{anisotropyarg}{list of arguments establishing spatial anisotropy. phi1 and phi2 control the stretch in two orthogonal directions (e.g., longitude and latitude) while the angle theta controls a counterclockwise rotation (default set to list(phi1 = 1, phi2 = 1 , theta = 0) for isotropic fields)}
}
\description{
Compute VAR model parameters to simulate parent Gaussian random vectors with specified spatiotemporal correlation structure using the method described by \href{https://doi.org/10.1145/937332.937333}{Biller and Nelson (2003)}
}
\details{
The fitting algorithm has \eqn{O(mxm)^3} complexity for a \eqn{(mxm)} field
or equivalently \eqn{O(d^3)} complexity for a \eqn{d}-dimensional vector.
Very large values of \eqn{(mxm)} (or \eqn{d}) and high order AR correlation
structures can be unpractical on standard machines.

Here, we give indicative CPU times for some settings, referring to a
Windows 10 Pro x64 laptop with Intel(R) Core(TM) i7-6700HQ CPU @ 2.60GHz,
4-core, 8 logical processors, and 32GB RAM. \cr:
CPU time:\cr
d = 100 or m = 10, p = 1: ~  0.4s \cr
d = 900 or m = 30, p = 1: ~  6.0s \cr
d = 900 or m = 30, p = 5: ~ 47.0s \cr
d = 2500 or m = 50, p = 1: ~100.0s
}
\examples{
## for multivariate simulation
coord <- cbind(runif(4)*30, runif(4)*30)

fit <- fitVAR(
  spacepoints = coord,
  p = 1,
  margdist ='burrXII',
  margarg = list(scale = 3,
                 shape1 = .9,
                 shape2 = .2),
  p0 = 0.8,
  stcsid = "clayton",
  stcsarg = list(scfid = "weibull",
                 tcfid = "weibull",
                 copulaarg = 2,
                 scfarg = list(scale = 20,
                               shape = 0.7),
                 tcfarg = list(scale = 1.1,
                               shape = 0.8))
)

dim(fit$alpha)
dim(fit$res.cov)

fit$m
fit$margarg
fit$margdist

## for random fields simulation
fit <- fitVAR(
  spacepoints = 10,
  p = 1,
  margdist ='burrXII',
  margarg = list(scale = 3, shape1 = .9, shape2 = .2),
  p0 = 0.8,
  stcsid = "clayton",
  stcsarg = list(scfid = "weibull", tcfid = "weibull",
                 copulaarg = 2,
                 scfarg = list(scale = 20, shape = 0.7),
                tcfarg = list(scale = 1.1, shape = 0.8))
)

dim(fit$alpha)
dim(fit$res.cov)

fit$m
fit$margarg
fit$margdist

}
