% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeN.R
\name{computeN}
\alias{computeN}
\title{Estimation of Size and Numbers of Cases and Controls in the Target Population of Active Treatment Recipients At Risk at the Biomarker Sampling Timepoint}
\usage{
computeN(Nrand, tau, taumax, VEtauToTaumax, VE0toTau, risk0, dropoutRisk,
  propCasesWithS)
}
\arguments{
\item{Nrand}{the number of participants randomized to the active treatment group}

\item{tau}{the biomarker sampling timepoint after randomization}

\item{taumax}{the time after randomization marking the end of the follow-up period for the clinical endpoint}

\item{VEtauToTaumax}{the treatment (vaccine) efficacy level between \eqn{\tau} and \eqn{\tau_{max}}}

\item{VE0toTau}{the treatment (vaccine) efficacy between 0 and \eqn{\tau}}

\item{risk0}{the overall placebo-group endpoint risk between \eqn{\tau} and \eqn{\tau_{max}}}

\item{dropoutRisk}{the risk of participant dropout between 0 and \eqn{\tau_{max}}}

\item{propCasesWithS}{the proportion of observed cases with a measured biomarker response}
}
\value{
A list with the following components:
\itemize{
  \item \code{N}: the total estimated number of active treatment recipients observed to be at risk at \eqn{\tau}
  \item \code{nCases}: the estimated number of clinical endpoint cases observed between \eqn{\tau} and \eqn{\tau_{max}} in the active treatment group
   \item \code{nControls}: the estimated number of controls observed to complete follow-up through \eqn{\tau_{max}} endpoint-free in the active treatment group
   \item \code{nCasesWithS}: the estimated number of clinical endpoint cases observed between \eqn{\tau} and \eqn{\tau_{max}} in the active treatment group with an available biomarker response
}
}
\description{
If the power calculation is done at the study design stage, the function estimates the size and numbers of cases and controls in the target population of active treatment recipients observed to be
at risk at the biomarker sampling timepoint.
}
\details{
The function estimates design parameters that are required as input to \code{\link{computePower}}. If the power calculation is done after the follow-up was completed, the estimates are replaced by the observed
counterparts for use as input parameters in \code{\link{computePower}}.

The calculations include options to account for participant dropout by specifying \code{dropoutRisk} as well as for incomplete sample storage by specifying \code{propCasesWithS}.

The estimation procedure considers the standard survival analysis framework with failure and censoring times denoted by \eqn{T} and \eqn{C}, respectively, and makes the following assumptions:
\enumerate{
  \item \eqn{T} and \eqn{C} are independent.
  \item \eqn{T|Z=0} follows an exponential distribution with rate \eqn{\theta_t} and \eqn{C|Z=0} follows an
     exponential distribution with rate \eqn{\theta_c}
  \item \eqn{RR_{\tau-\tau_{max}} := P(T <= \tau_{max}|T> \tau, Z=1)/P(T <= \tau_{max}|T> \tau, Z=0)} is assumed to be equal to \eqn{ P(T <= t|T> \tau, Z=1)/P(T <= t|T> \tau, Z=0)} for all \eqn{t \in (\tau,\tau_{max}]}.
}
}
\examples{
Nrand = 4100
tau = 3.5
taumax = 24
VEtauToTaumax = 0.75
VE0toTau = 0.75/2
risk0 = 0.034
dropoutRisk = 0.1
propCasesWithS = 1
computeN(Nrand, tau, taumax, VEtauToTaumax, VE0toTau, risk0, dropoutRisk, propCasesWithS)

}
\seealso{
\code{\link{computePower}}
}
