% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionEstParmFunc.R
\name{PredictionEstParmFunc}
\alias{PredictionEstParmFunc}
\title{Predicting using dirichl-gLV}
\usage{
PredictionEstParmFunc(
  paramEstimadosFinal,
  EspecieMaxima,
  alpha,
  K,
  esperanza,
  Var,
  E,
  Tt
)
}
\arguments{
\item{paramEstimadosFinal}{The estimate parameters. Vector equal to \code{c(tau,as.vector( pam))} where:

\itemize{
  \item pam  Matrix. Each row has the parameters of each bacteria. Following our example, pam has the parameters placed as follows:
  \tabular{rrrr}{
 r1 \tab  a11  \tab  a12\cr
 r2 \tab  a21 \tab   a22 }
  \item tau  Number. Value of the tau parameter in the model
  }}

\item{EspecieMaxima}{Row in which the bacteria chosen as reference is in \code{especie}.This bacteria is used as reference in the alr transformation that the model does.}

\item{alpha}{Matrix that contains at the row i the dirichlet parameter of the bacteria i at t=1,2,3,...,\code{Tt}.}

\item{K}{Number. The function will calculate the value of the expected value and the variance at \code{Tt} and predict for the time points t=\code{Tt}+1,..,K. To predict all the time points available at the data we K=dim(especie.All)-1}

\item{esperanza}{Matrix that contains at row i the expected value of the bacterial taxa of bacteria i at t=1,2,3,...,\code{Tt}-1.}

\item{Var}{Matrix that contains at row i the variance of the bacterial taxa of bacteria i at t=1,2,3,...,\code{Tt}-1.}

\item{E}{Number of bacteria available}

\item{Tt}{Number of time points available}
}
\value{
Returns a list with:

\itemize{
   \item ExpectedValue.All:  Matrix. Matrix that contains at row i the expected value of the bacteria i at all time points t=2,...,K. The bacteria are placed at the same order than in \code{especies}.
   \item VarianceValue.All:  Matrix. Matrix that contains at row i the variance of the bacteria i at all time points t=2,...,K. The bacteria are placed at the same order than in \code{especies}.
  \item DirichlerParam.All:  Matrix. Matrix that contains at row i the dirichlet parameter of the bacteria i at all time points t=2,...,K. The bacteria are placed at the same order than in \code{especies}.
  }
}
\description{
This function calculates the expected value and variance of the bacteria at time point \code{Tt}. Then, this function calculates the expected value and variance of the bacteria at time point t=(\code{Tt}+1),...,K
}
\details{
The regression of this model, in an example with three bacteria, is defined by

\deqn{r_{1}\cdot log(x_{1}(t)/x_{3}(t))+log(x_{1}(t)/x_{3}(t))\cdot [a_{11}\cdot log(x_{1}(t)/x_{3}(t))(t)+a_{12}\cdot log(x_{2}(t)/x_{3}(t))] }
\deqn{r_{2}\cdot log(x_{2}(t)/x_{3}(t))+log(x_{2}(t)/x_{3}(t))\cdot [a_{21}\cdot log(x_{1}(t)/x_{3}(t))(t)+a_{22}\cdot log(x_{2}(t)/x_{3}(t))] }
}
\examples{

pam.ini=rbind(c(0.1,0.2,0.3),c(0.4,0.5,0.6))
paramEstimadosFinal=c(5, as.vector(pam.ini))
EspecieMaxima=3
alpha=cbind(c(2,2,3),c(1,1,3))
K=3
esperanza=cbind(c(0.2,0.3,0.5))
Var=cbind(c(0.2,0.3,0.5))
E=3
Tt=2

PredictionEstParmFunc(paramEstimadosFinal,EspecieMaxima, alpha,K,esperanza,Var,E,Tt )

}
\references{
Creus-Martí, I. and Moya, A. and Santonja, F. J. (2018). A Statistical Model with a Lotka-Volterra Structure for Microbiota Data. Lucas Jodar, Juan Carlos Cortes and Luis Acedo,  Modelling or engineering and human behavior 2018, Instituto Universitario de Matematica Multidisciplinar. ISBN: 978-84-09-07541-6
}
