% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{evaluate_validation_external_by_metrics}
\alias{evaluate_validation_external_by_metrics}
\title{Evaluate external validations by algorithm.}
\usage{
evaluate_validation_external_by_metrics(df)
}
\arguments{
\item{df}{data matrix or data frame with the result of running the clustering
algorithm.}
}
\value{
a data.frame with all the algorithms that obtain the best results
regardless of the dissimilarity measure used.
}
\description{
Method that calculates which algorithm behaves best for the
datasets provided.
}
\details{
The operation of this method is to determine which algorithm has
better behavior regardless of the measure of dissimilarity calculated, so we
can determine which algorithm eturns better results from the attributes and
measures of dissimilarity.
}
\examples{

result = clustering(
               df = cluster::agriculture,
               min = 4,
               max = 5,
               algorithm='kmeans_arma',
               metrics=c("precision"),
               attributes = TRUE
         )

evaluate_validation_external_by_metrics(result)

\dontrun{
evaluate_validation_external_by_metrics(result$result)
}

}
