% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{clustering}
\alias{clustering}
\title{Execute a list of datasets from a route or a dataframe}
\usage{
clustering(
  path = CONST_NULL,
  df = CONST_NULL,
  packages = CONST_NULL,
  algorithm = CONST_NULL,
  min = CONST_NULL,
  max = CONST_NULL,
  metrics = CONST_NULL,
  variables = CONST_NULL
)
}
\arguments{
\item{path}{path where the datasets are located.}

\item{df}{data matrix or data frame, or dissimilarity matrix, depending on the value of the argument.}

\item{packages}{array defining the clustering package. The seven packages implemented are: cluster, ClusterR, advclust, amap, apcluster,
gama, pvclust. \cr By default runs all packages.}

\item{algorithm}{array with the algorithms that implement the package. The algorithms implemented are: fuzzy_cm,fuzzy_gg,fuzzy_gk,
hclust,apclusterK,agnes,clara,daisy, \cr diana,fanny,mona,pam,gmm,kmeans_arma,kmeans_rcpp,mini_kmeans,gama,\cr pvclust.}

\item{min}{minimum number of clusters. at least one must be.}

\item{max}{maximum number of clusters. cluster_max must be greater or equal cluster_min.}

\item{metrics}{array defining the metrics avalaible in the package. The night metrics implemented are: entropy, variation_information,\cr
precision,recall,f_measure,fowlkes_mallows_index,connectivity,dunn,silhouette.}

\item{variables}{accepts Boolean values. If true as a result it shows the variable that behaves best otherwise it shows the value of the executed metric.}
}
\value{
returns a matrix with the result of running all the metrics of the algorithms contained in the packages we indicated.
}
\description{
Execute a list of datasets from a route or a dataframe
}
\examples{

clustering(df = cluster::agriculture, min = 4, max = 5, algorith='gmm', variables = TRUE)

}
