% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECS.R
\name{merge_partitions}
\alias{merge_partitions}
\title{Merge Partitions}
\usage{
merge_partitions(partition_list, ecs_thresh = 1, ncores = 1, order = TRUE)
}
\arguments{
\item{partition_list}{A list of flat disjoint membership vectors.}

\item{ecs_thresh}{A numeric: the ecs threshold.}

\item{ncores}{The number of parallel R instances that will run the code.
If the value is set to 1, the code will be run sequentially.}

\item{order}{A logical: if TRUE, order the partitions based on their frequencies.}
}
\value{
a list of the merged partitions
}
\description{
Merge flat disjoint clusterings whose pairwise ECS score is
above a given threshold. The merging is done using a complete linkage approach.
}
\examples{
initial_list = list(c(1,1,2), c(2,2,2), c('B','B','A'))
merge_partitions(initial_list, 0.99)
}
