% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{mni}
\alias{mni}
\title{Modified Nesterov Index}
\usage{
mni(dew_point, taverage, rh, pr, data_names = NULL, time.scale = YEAR,
  na.rm = FALSE)
}
\arguments{
\item{dew_point}{dew point}

\item{taverage}{medium temperature}

\item{rh}{relative humidity}

\item{pr}{precipitation}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
MNI
}
\description{
The Modified Nesterov Index (MNI) reflects the relationship between observed weather conditions and fire occurrence. It is a cumulative index  computed from daily temperature and dewpoint temperature, which is reset when a certain precipitation value is reached.
}
\examples{
data(data_all)
mni(dew_point=data_all$dewpoint, taverage=data_all$tg, rh=data_all$humidity, pr=data_all$rr)
}
\references{
Groisman, P.Y., et al., 2007. Global and Planetary Change 56, 371–386.
}
