% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDI.R
\name{RDI}
\alias{RDI}
\title{Riou's drought index}
\usage{
RDI(series, clim_norm = NULL, first.yr = NULL, last.yr = NULL,
  TAW = 200, coeff_rad, coeff_Hargr = rep(0.75, 12), quant = c(0, 0.1,
  0.5))
}
\arguments{
\item{series}{series of mean monthly weather values}

\item{clim_norm}{the reference climatic values for each month, used for gap filling. Default is \code{NULL} (no replacement of missing values)}

\item{first.yr}{of the period over which water balance is calculated. Default is  \code{NULL} (calculations start with the first year of the series)}

\item{last.yr}{of the period over which water balance is calculated. Default is  \code{NULL} (calculations start with the last year of the series)}

\item{TAW}{total available water content of soil}

\item{coeff_rad}{vector of solar radiation coefficients (12 values) for calculation of potential evapotranspiration}

\item{coeff_Hargr}{(vector of monthly) correction coefficient(s) for Hargreaves' equation}

\item{quant}{vector of quantiles for the statistical ranking of the year representative for balance (0..1)}
}
\value{
A two-column table reporting Riou's drought indices for each quantile chosen (one line each, minimum is 1). Both "harvest time" and minimum values
are calculated (see details).
}
\description{
Calculation of Riou's drought index described in OIV bio-climatic indices for viticulture (see references)
}
\details{
For full description of algorithm see OIV standards at http://www.oiv.int/oiv/info/enresolution2012?lang=en and the references:  Riou, 1994; Tonietto, 1999.
Evapotranspiration is calculated by Hargreaves' equation (see \code{\link{arid}}).

\code{series} is a data frame of the monthly series (means) of: cumulated precipitation (mm), minimum temperature, maximum temperature, mean temperature (optional) 
- all in deg. C. Includes the following columns (and names): "year", "month", "P", "Tn", "Tx", "Tm" (optional), for precipitation, minimum, maximum and 
mean temperature, respectively. If \code{Tm} is missing it is calculated as (Tn + Tx)/2. Format is the same of \code{lista_cli}.

\code{clim_norm} is a monthly data frame of 12 climate normals, with the same column names of \code{series}, except "year".
It can be the output of function \code{\link{climate}}. If \code{clim_norm} is not  \code{NULL}, any missing value in 
the monthly series is substituted by the corresponding climatic value in \code{clim_norm}.

A default value of 200 mm for \code{TAW} is suggested by the authors of the index. It can be changed according to the known
pedological features of soil.

\code{coeff_rad} corresponds to the mean monthly extra-atmospheric radiation (see function \code{\link{ExAtRa}}). It is required in Hargreaves' equation.

\code{coeff_Hargr} is either a single value or a vector of 12 coefficients to adjust Hargreaves' estimation of potential evapotranspiration. 
From calibration in 6 stations from the same network of \code{Trent_climate}, its average value is 0.75.

\code{quant_vector} a vector of minimum one element. 0 yields minimum absolute case, 0.5 the median. Values range from 0 to 1 (inappropropriate if > 0.5).

The algorithm described in OIV assesses water balance at the last month of the ripenining period, early autumn. However, in
humid or sub-humid climates the driest period for soil generally falls in summer. For this reason, the output table reports 
both cases ("harvest" time value and monthly minimum over the season, "WB_harv" and "WB_min", respectfully). Harvest time is 
conventionally September (N emisphere) or March (S emisphere).
}
\examples{
data(Trent_climate)
RDI(lista_cli[[1]], clim_norm=clima_81_10[[1]], first.yr=1981, last.yr=2010, coeff_rad=coeff_rad)

}
\author{
Emanuele Eccel
}
\references{
Riou, C. 1994. Le determinisme climatique de la maturation du raisin: application au zonage de la teneur en sucre dans la Communaute Europeenne (E. Commission, ed.).
Office des Publications Officielles des Communautes Europeennes, Luxembourg, 322p.

Tonietto, J. 1999. Les Macroclimats Viticoles Mondiaux et l'Influence du Mesoclimat sur la Typicite de la Syrah et du Muscat de Hambourg dans le Sud de la France 
Methodologie de Caracterisation. These de doctorat, Ecole Nationale Superieure Agronomique de Montpellier, Montpellier (France), 216p.
}
\seealso{
\code{\link{oiv_ind}},  \code{\link{arid}}
}

