% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumulativecurve.R
\name{cumulativecurve}
\alias{cumulativecurve}
\title{Cumulative claims-awards curve}
\usage{
cumulativecurve(E, d, Rules, col = NULL, legend = TRUE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{Rules}{The rules: AA, APRO, CE, CEA, CEL, DT, MO, PIN, PRO, RA, Talmud.}

\item{col}{The colors. If col = NULL then the sequence of default colors is:
c("red", "blue", "green", "yellow", "pink", "coral4", "darkgray", "burlywood3", "black", "darkorange", "darkviolet").}

\item{legend}{A logical value. The color legend is shown if legend = TRUE.}
}
\value{
The graphical representation of the cumulative claims-awards curves of a rule (or several rules) for a claims problem.
}
\description{
This function returns the cumulative claims-awards curve of a rule for a claims problem.
}
\details{
Let \eqn{E> 0} be the endowment to be divided and \eqn{d\in \mathcal{R}^n}{d} the vector of claims
with \eqn{d\ge 0} and such that the sum of claims \eqn{D=\sum_{i=1}^{n} d_i\ge E}{D=\sum di} exceeds the endowment.

Rearrange the claims from small to large, \eqn{0 \le d_1 \le...\le d_n}{%
0 \le d1 \le...\le dn}. The cumulative claims-awards curve allows us
to compare the division recommended by a specific rule \eqn{R} with the division that preserves the proportions of the
claims, the proportional rule.

The cumulative claims-awards curve of a rule \eqn{R} for the claims problem \eqn{(E,d)} is the polygonal path connecting the \eqn{n+1} points
\deqn{(0,0), (\frac{d_1}{D},\frac{R_1(E,d)}{E}),\dots,(\frac{\sum_{i=1}^{n-1}d_i}{D},\frac{\sum_{i=1}^{n-1}R_i(E,d)}{E}),(1,1).}{%
(0,0) , (d1/D,R1(E,d)/E) , ((d1+d2)/D , (R1(E,d)+R2(E,d))/E ,\dots , (1,1).}
Basically, it represents the percentage of the endowment assigned by the rule to each cumulative proportion of claims.

The cumulative claims-awards curve fully captures the Lorenz ranking of rules:
if a rule \eqn{R} Lorenz-dominates a rule \eqn{R'} then, for each claims problem, the cumulative claims-awards  curve of \eqn{R}
lies above the cumulative curve of \eqn{R'}.
}
\examples{
E=10
d=c(2,4,7,8)
Rules=c(AA,RA,Talmud,CEA,CEL)
cumulativecurve(E,d,Rules)
}
\references{
Lorenz, M. O. (1905). Methods of measuring the concentration of wealth. Publications of the American statistical association, 9(70), 209-219.

Mirás Calvo, M.A., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2021). Deviation from proportionality and Lorenz-dominance between
the average of awards and the standard rules for claims problems. Working paper 2021-01, ECOBAS.
}
\seealso{
\link{proportionalityindex}, \link{indexpath}, \link{lorenzcurve}, \link{giniindex}, \link{lorenzdominance},  \link{PRO}.
}
