% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HR_test.r
\name{HR_test}
\alias{HR_test}
\title{Hermans-Rasson test function}
\usage{
HR_test(data, original = F, iter = 9999)
}
\arguments{
\item{data}{A vector of class 'circular', or numeric vector of 
angles measured in radians}

\item{original}{A logical of whether or not to run the original 
version of the Hermans-Rasson test or the newer version described
in Landler et al. (2019) doi: 10.1186/s12898-019-0246-8 (default = F)}

\item{iter}{The number of bootstrap replicates to perform in order 
to estimate the p-value of the test. (default = 9999)}
}
\value{
A numeric vector of the test statistic (T) and associated p-value
}
\description{
Perform variants of the Hermans-Rasson test.
}
\examples{
testdata = circular::rvonmises(20, mu = circular::circular(pi), kappa = 3)
HR_test(testdata, iter = 999)
}
\keyword{Hermans-Rasson}
\keyword{test}
