/*
 * Decompiled with CFR 0.152.
 */
package core.model;

import core.graph.ChordalGraph;
import core.graph.CliqueGraphEdge;
import core.model.Couple;
import core.model.GraphAction;
import core.model.PValueScoredGraphAction;
import core.stats.EntropyComputer;
import core.stats.MessageLengthFactorialComputer;
import core.stats.MyPriorityQueue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.math3.util.FastMath;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;
import org.jgrapht.graph.DefaultEdge;

public class DecomposableModel {
    public ChordalGraph graph;
    TreeMap<GraphAction, List<GraphAction>> actionsForInteraction;
    Double entropy;
    Double encodingLength;
    boolean entropyComputed = false;
    long nbParameters = -1L;
    int[] dimensionsForVariables;

    public DecomposableModel(int[] variables, int[] dimensionsForVariables) {
        this.graph = new ChordalGraph();
        int[] nArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            int var = nArray[n2];
            this.graph.addVertex(var);
            ++n2;
        }
        this.graph.initStructures();
        this.actionsForInteraction = new TreeMap();
        int i = 0;
        while (i < variables.length) {
            int j = i + 1;
            while (j < variables.length) {
                Couple<Integer> edge = new Couple<Integer>(i, j);
                ArrayList<GraphAction> actionsList = new ArrayList<GraphAction>();
                GraphAction action = new GraphAction(GraphAction.ActionType.ADD, edge);
                actionsList.add(action);
                this.actionsForInteraction.put(action, actionsList);
                ++j;
            }
            ++i;
        }
        this.dimensionsForVariables = dimensionsForVariables;
    }

    public DecomposableModel(DecomposableModel model) {
        this.graph = (ChordalGraph)((Object)model.graph.clone());
        this.actionsForInteraction = null;
        this.entropy = model.entropy;
        this.entropyComputed = model.entropyComputed;
        this.dimensionsForVariables = model.dimensionsForVariables;
    }

    public void performAction(GraphAction actionToPerform, DecomposableModel fromModel) {
        List<GraphAction> actionsToPerform = fromModel.actionsForInteraction.get(actionToPerform);
        for (GraphAction action : actionsToPerform) {
            switch (action.type) {
                case ADD: {
                    this.graph.addSecuredEdge(action.getV1(), action.getV2());
                    break;
                }
                case REMOVE: {
                    this.graph.removeSecuredEdge(action.getV1(), action.getV2());
                    break;
                }
            }
        }
        this.entropyComputed = false;
        this.entropy = Double.NaN;
        this.nbParameters = -1L;
    }

    public void performAction(GraphAction actionToPerform, DecomposableModel fromModel, MyPriorityQueue pq) {
        List<GraphAction> actionsToPerform = fromModel.actionsForInteraction.get(actionToPerform);
        for (GraphAction action : actionsToPerform) {
            switch (action.type) {
                case ADD: {
                    this.graph.addSecuredEdge(action.getV1(), action.getV2(), pq);
                    break;
                }
                case REMOVE: {
                    break;
                }
            }
        }
        this.entropyComputed = false;
        this.entropy = Double.NaN;
        this.nbParameters = -1L;
    }

    public void computeAvailableModifications() {
        this.computeAvailableModifications(false);
    }

    public void computeAvailableModifications(boolean backward) {
        this.actionsForInteraction = new TreeMap();
        int v1 = 0;
        while (v1 < this.dimensionsForVariables.length) {
            int v2 = v1 + 1;
            while (v2 < this.dimensionsForVariables.length) {
                ArrayList<GraphAction> actionsList = new ArrayList<GraphAction>();
                GraphAction currentAction = null;
                if (this.graph.isEdgeAddable(v1, v2)) {
                    currentAction = new GraphAction(GraphAction.ActionType.ADD, v1, v2);
                    actionsList.add(currentAction);
                }
                if (!actionsList.isEmpty()) {
                    this.actionsForInteraction.put(currentAction, actionsList);
                }
                ++v2;
            }
            ++v1;
        }
    }

    public TreeSet<GraphAction> getAvailableInteractions() {
        return new TreeSet<GraphAction>(this.actionsForInteraction.keySet());
    }

    public Double entropyDiffIfAdding(Integer a, Integer b, EntropyComputer computer) {
        return this.entropyDiffIfAdding(a, b, computer, false);
    }

    public Double entropyDiffIfAdding(Integer a, Integer b, EntropyComputer computer, boolean verbose) {
        BitSet Sab = this.graph.getSeparator(a, b);
        BitSet Sabua = (BitSet)Sab.clone();
        BitSet Sabub = (BitSet)Sab.clone();
        BitSet Sabuaub = (BitSet)Sab.clone();
        Sabua.set(a);
        Sabub.set(b);
        Sabuaub.set(a);
        Sabuaub.set(b);
        Double entropy = 0.0;
        Double tmp = computer.computeEntropy(Sab);
        if (tmp == null) {
            entropy = null;
            return entropy;
        }
        entropy = entropy - tmp;
        if (verbose) {
            System.out.println("-" + Sab + ":" + tmp);
        }
        if ((tmp = computer.computeEntropy(Sabua)) == null) {
            entropy = null;
            return entropy;
        }
        entropy = entropy + tmp;
        if (verbose) {
            System.out.println("+" + Sabua + ":" + tmp);
        }
        if ((tmp = computer.computeEntropy(Sabub)) == null) {
            entropy = null;
            return entropy;
        }
        entropy = entropy + tmp;
        if (verbose) {
            System.out.println("+" + Sabub + ":" + tmp);
        }
        if ((tmp = computer.computeEntropy(Sabuaub)) == null) {
            entropy = null;
            return entropy;
        }
        entropy = entropy - tmp;
        if (verbose) {
            System.out.println("-" + Sabuaub + ":" + tmp);
        }
        return entropy;
    }

    public int treeWidthIfAdding(Integer a, Integer b) {
        BitSet Sab = this.graph.getSeparator(a, b);
        BitSet Sabuaub = (BitSet)Sab.clone();
        Sabuaub.set(a);
        Sabuaub.set(b);
        return Sabuaub.cardinality();
    }

    public long nbParametersDiffIfAdding(Integer a, Integer b) {
        BitSet Sab = this.graph.getSeparator(a, b);
        BitSet Sabua = (BitSet)Sab.clone();
        BitSet Sabub = (BitSet)Sab.clone();
        BitSet Sabuaub = (BitSet)Sab.clone();
        Sabua.set(a);
        Sabub.set(b);
        Sabuaub.set(a);
        Sabuaub.set(b);
        long diffNbParameters = 0L;
        int tmpNBDF = 1;
        int var = Sab.nextSetBit(0);
        while (var >= 0) {
            tmpNBDF *= this.dimensionsForVariables[var];
            var = Sab.nextSetBit(var + 1);
        }
        diffNbParameters += (long)(--tmpNBDF);
        tmpNBDF = 1;
        var = Sabua.nextSetBit(0);
        while (var >= 0) {
            tmpNBDF *= this.dimensionsForVariables[var];
            var = Sabua.nextSetBit(var + 1);
        }
        diffNbParameters -= (long)(--tmpNBDF);
        tmpNBDF = 1;
        var = Sabuaub.nextSetBit(0);
        while (var >= 0) {
            tmpNBDF *= this.dimensionsForVariables[var];
            var = Sabuaub.nextSetBit(var + 1);
        }
        diffNbParameters += (long)(--tmpNBDF);
        tmpNBDF = 1;
        var = Sabub.nextSetBit(0);
        while (var >= 0) {
            tmpNBDF *= this.dimensionsForVariables[var];
            var = Sabub.nextSetBit(var + 1);
        }
        return diffNbParameters -= (long)(--tmpNBDF);
    }

    public long nbParametersDiffIfAdding(Integer a, Integer b, BitSet Sab) {
        BitSet Sabua = (BitSet)Sab.clone();
        BitSet Sabub = (BitSet)Sab.clone();
        BitSet Sabuaub = (BitSet)Sab.clone();
        Sabua.set(a);
        Sabub.set(b);
        Sabuaub.set(a);
        Sabuaub.set(b);
        long diffNbParameters = 0L;
        int tmpNBDF = 1;
        int var = Sab.nextSetBit(0);
        while (var >= 0) {
            tmpNBDF *= this.dimensionsForVariables[var];
            var = Sab.nextSetBit(var + 1);
        }
        diffNbParameters += (long)(--tmpNBDF);
        tmpNBDF = 1;
        var = Sabua.nextSetBit(0);
        while (var >= 0) {
            tmpNBDF *= this.dimensionsForVariables[var];
            var = Sabua.nextSetBit(var + 1);
        }
        diffNbParameters -= (long)(--tmpNBDF);
        tmpNBDF = 1;
        var = Sabuaub.nextSetBit(0);
        while (var >= 0) {
            tmpNBDF *= this.dimensionsForVariables[var];
            var = Sabuaub.nextSetBit(var + 1);
        }
        diffNbParameters += (long)(--tmpNBDF);
        tmpNBDF = 1;
        var = Sabub.nextSetBit(0);
        while (var >= 0) {
            tmpNBDF *= this.dimensionsForVariables[var];
            var = Sabub.nextSetBit(var + 1);
        }
        return diffNbParameters -= (long)(--tmpNBDF);
    }

    public long getNbParameters() {
        if (this.nbParameters == -1L) {
            int var;
            int tmpNBDF;
            List<BitSet> cliques = this.graph.getCliquesBFS();
            List<BitSet> separators = this.graph.getSeparatorsBFS();
            this.nbParameters = 0L;
            for (BitSet clique : cliques) {
                tmpNBDF = 1;
                var = clique.nextSetBit(0);
                while (var >= 0) {
                    tmpNBDF *= this.dimensionsForVariables[var];
                    var = clique.nextSetBit(var + 1);
                }
                this.nbParameters += (long)(--tmpNBDF);
            }
            for (BitSet separator : separators) {
                tmpNBDF = 1;
                var = separator.nextSetBit(0);
                while (var >= 0) {
                    tmpNBDF *= this.dimensionsForVariables[var];
                    var = separator.nextSetBit(var + 1);
                }
                this.nbParameters -= (long)(--tmpNBDF);
            }
        }
        return this.nbParameters;
    }

    public double getMessageLength(MessageLengthFactorialComputer computer) {
        int var;
        int tmpNParam;
        double length = 0.0;
        List<BitSet> cliques = this.graph.getCliquesBFS();
        List<BitSet> separators = this.graph.getSeparatorsBFS();
        for (BitSet clique : cliques) {
            tmpNParam = 1;
            var = clique.nextSetBit(0);
            while (var >= 0) {
                tmpNParam *= this.dimensionsForVariables[var];
                var = clique.nextSetBit(var + 1);
            }
            length += (double)(--tmpNParam) * computer.getLogFromTable(computer.getNbInstances() + 1);
            length += computer.computeLengthData(clique);
        }
        for (BitSet separator : separators) {
            tmpNParam = 1;
            var = separator.nextSetBit(0);
            while (var >= 0) {
                tmpNParam *= this.dimensionsForVariables[var];
                var = separator.nextSetBit(var + 1);
            }
            length -= (double)(--tmpNParam) * computer.getLogFromTable(computer.getNbInstances() + 1);
            length -= computer.computeLengthData(separator);
        }
        return length;
    }

    public String toString() {
        List<BitSet> cliques = this.graph.getCliquesBFS();
        String res = "";
        for (BitSet clique : cliques) {
            res = String.valueOf(res) + "[";
            int var = clique.nextSetBit(0);
            while (var >= 0) {
                res = String.valueOf(res) + var + " ";
                var = clique.nextSetBit(var + 1);
            }
            res = String.valueOf(res) + "]";
        }
        return res;
    }

    public String toString(String[] variableNames) {
        List<BitSet> cliques = this.graph.getCliques();
        String res = "";
        for (BitSet clique : cliques) {
            res = String.valueOf(res) + "[";
            int var = clique.nextSetBit(0);
            while (var >= 0) {
                res = String.valueOf(res) + variableNames[var] + " ";
                var = clique.nextSetBit(var + 1);
            }
            res = String.valueOf(res) + "]";
        }
        return res;
    }

    public void exportDOT(File file, String[] variableNames) {
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(file), true);
            out.println("graph G{");
            for (DefaultEdge edge : this.graph.edgeSet()) {
                if (variableNames == null) {
                    out.println(this.graph.getEdgeSource(edge) + "--" + this.graph.getEdgeTarget(edge));
                    continue;
                }
                out.println("\"" + variableNames[(Integer)this.graph.getEdgeSource(edge)] + "\"--\"" + variableNames[(Integer)this.graph.getEdgeTarget(edge)] + "\"");
            }
            out.println("}");
            out.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    public void exportJSON(File file, String[] variableNames) {
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(file), true);
            out.println("{");
            out.println("\t\"nodes\": [");
            ArrayList listNodes = new ArrayList(this.graph.vertexSet());
            Integer firstNode = (Integer)listNodes.get(0);
            out.println("\t\t{");
            out.println("\t\t\t\"id\":\"" + firstNode + "\",");
            if (variableNames != null) {
                out.println("\t\t\t\"text\":\"" + variableNames[firstNode] + "\",");
            }
            out.println("\t\t\t\"Type\":\"Symptom\"");
            out.println("\t\t}");
            int i = 1;
            while (i < listNodes.size()) {
                Integer node = (Integer)listNodes.get(i);
                out.println("\t\t,{");
                out.println("\t\t\t\"id\":\"" + node + "\",");
                if (variableNames != null) {
                    out.println("\t\t\t\"text\":\"" + variableNames[node] + "\",");
                }
                out.println("\t\t\t\"Type\":\"Symptom\"");
                out.println("\t\t}");
                ++i;
            }
            out.println("\t],\"links\": [");
            ArrayList listEdges = new ArrayList(this.graph.edgeSet());
            if (!listEdges.isEmpty()) {
                DefaultEdge firstEdge = (DefaultEdge)listEdges.get(0);
                Integer source = (Integer)this.graph.getEdgeSource(firstEdge);
                Integer target = (Integer)this.graph.getEdgeTarget(firstEdge);
                out.println("\t\t{");
                out.println("\t\t\t\"source\":\"" + source + "\",");
                out.println("\t\t\t\"target\":\"" + target + "\"");
                out.println("\t\t}");
                int i2 = 1;
                while (i2 < listEdges.size()) {
                    DefaultEdge edge = (DefaultEdge)listEdges.get(i2);
                    source = (Integer)this.graph.getEdgeSource(edge);
                    target = (Integer)this.graph.getEdgeTarget(edge);
                    out.println("\t\t,{");
                    out.println("\t\t\t\"source\":\"" + source + "\",");
                    out.println("\t\t\t\"target\":\"" + target + "\"");
                    out.println("\t\t}");
                    ++i2;
                }
            }
            out.println("\t]");
            out.println("}");
            out.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    public void exportDOTCG(File file, String[] variableNames) {
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(file), true);
            out.println("graph G{");
            for (CliqueGraphEdge edge : this.graph.cg.edgeSet()) {
                BitSet source = (BitSet)this.graph.cg.getEdgeSource((Object)edge);
                BitSet target = (BitSet)this.graph.cg.getEdgeTarget((Object)edge);
                BitSet inter = (BitSet)source.clone();
                inter.and(target);
                if (variableNames == null) {
                    out.println(this.graph.cg.getEdgeSource((Object)edge) + "--" + this.graph.cg.getEdgeTarget((Object)edge));
                    continue;
                }
                out.print("\"");
                int v = source.nextSetBit(0);
                while (v >= 0) {
                    out.print(String.valueOf(variableNames[v]) + ";");
                    v = source.nextSetBit(v + 1);
                }
                out.print("\"--\"");
                v = target.nextSetBit(0);
                while (v >= 0) {
                    out.print(String.valueOf(variableNames[v]) + ";");
                    v = target.nextSetBit(v + 1);
                }
                out.print("\" [label = \"");
                v = inter.nextSetBit(0);
                while (v >= 0) {
                    out.print(String.valueOf(variableNames[v]) + ";");
                    v = inter.nextSetBit(v + 1);
                }
                out.println("\"]");
            }
            out.println("}");
            out.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    public DirectedAcyclicGraph<Integer, DefaultEdge> getBayesianNetwork() throws DirectedAcyclicGraph.CycleFoundException {
        return this.graph.getBayesianNetwork();
    }

    public int getTreeWidth() {
        return this.graph.getTreeWidth();
    }

    public boolean containsInteraction(Integer v1, Integer v2) {
        return this.graph.containsEdge(v1, v2);
    }

    public TreeSet<Couple<Integer>> getInteractions() {
        TreeSet<Couple<Integer>> interactions = new TreeSet<Couple<Integer>>();
        int v1 = 0;
        while (v1 < this.dimensionsForVariables.length) {
            int v2 = v1 + 1;
            while (v2 < this.dimensionsForVariables.length) {
                if (this.containsInteraction(v1, v2)) {
                    interactions.add(new Couple<Integer>(v1, v2));
                }
                ++v2;
            }
            ++v1;
        }
        return interactions;
    }

    public ChordalGraph getGraph() {
        return this.graph;
    }

    public List<BitSet> getCliques() {
        return this.graph.getCliques();
    }

    public List<BitSet> getCliquesBFS() {
        return this.graph.getCliquesBFS();
    }

    public List<BitSet> getSeparators() {
        return this.graph.getSeparatorsBFS();
    }

    public void exportGEXF(File file, String[] variableNames, int[] frequencies, ArrayList<GraphAction> operationsPerformed) {
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(file), true);
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.println("<gexf xmlns=\"http://www.gexf.net/1.2draft\" xmlns:viz=\"http://www.gexf.net/1.1draft/viz\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.gexf.net/1.2draft http://www.gexf.net/1.2draft/gexf.xsd\" version=\"1.2\">");
            out.println("\t<graph mode=\"static\" defaultedgetype=\"undirected\">");
            ArrayList listNodes = new ArrayList(this.graph.vertexSet());
            out.println("\t\t<nodes>");
            int i = 0;
            while (i < listNodes.size()) {
                Integer node = (Integer)listNodes.get(i);
                out.print("\t\t\t<node id=\"" + node + "\"");
                if (variableNames != null) {
                    out.print(" label=\"" + variableNames[node] + "\"");
                }
                out.println(">");
                if (frequencies != null) {
                    out.println("\t\t\t\t<viz:size value=\"" + FastMath.log((double)frequencies[node]) + "\"/>");
                } else {
                    out.println("\t\t\t\t<viz:size value=\"1\"/>");
                }
                out.print("\t\t\t</node>");
                ++i;
            }
            out.println("\t\t</nodes>");
            out.println("\t\t<edges>");
            if (!operationsPerformed.isEmpty()) {
                i = 0;
                while (i < operationsPerformed.size()) {
                    PValueScoredGraphAction action = (PValueScoredGraphAction)operationsPerformed.get(i);
                    Integer source = action.getV1();
                    Integer target = action.getV2();
                    out.print("\t\t\t<edge id=\"" + i + "\" source=\"" + source + "\" target=\"" + target + "\" weight=\"" + action.entropy + "\" />");
                    ++i;
                }
            }
            out.println("\t\t</edges>");
            out.println("\t</graph>");
            out.println("</gexf>");
            out.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    public void exportDOT(File file, String[] variableNames, int[] frequencies, ArrayList<GraphAction> operationsPerformed) {
        try {
            PValueScoredGraphAction action;
            PrintWriter out = new PrintWriter(new FileOutputStream(file), true);
            out.println("graph Chordalysis{");
            out.println("\tgraph [K=1.0 fontsize=14 overlap=\"10:\" splines=\"true\"];");
            out.println("\tratio = auto;");
            ArrayList listNodes = new ArrayList(this.graph.vertexSet());
            double minFreq = Double.MAX_VALUE;
            double maxFreq = 0.0;
            if (frequencies != null) {
                int[] nArray = frequencies;
                int n = frequencies.length;
                int n2 = 0;
                while (n2 < n) {
                    int f = nArray[n2];
                    double freq = Math.sqrt(f);
                    if (freq < minFreq) {
                        minFreq = freq;
                    }
                    if (maxFreq < freq) {
                        maxFreq = freq;
                    }
                    ++n2;
                }
            }
            int i = 0;
            while (i < listNodes.size()) {
                Integer node = (Integer)listNodes.get(i);
                out.print("\t\"" + node + "\"");
                out.print(" [shape=\"ellipse\" ");
                if (variableNames != null) {
                    out.print("label=\"" + variableNames[node] + "\" ");
                }
                double fontSize = frequencies != null ? 10.0 + (Math.sqrt(frequencies[node]) - minFreq) / (maxFreq - minFreq) * 20.0 : 10.0;
                out.print("fontsize=" + fontSize + " ");
                out.println("];");
                ++i;
            }
            double minEntropy = Double.MAX_VALUE;
            double maxEntropy = 0.0;
            if (operationsPerformed != null) {
                int i2 = 0;
                while (i2 < operationsPerformed.size()) {
                    action = (PValueScoredGraphAction)operationsPerformed.get(i2);
                    double H = action.entropy;
                    if (H < minEntropy) {
                        minEntropy = H;
                    }
                    if (maxEntropy < H) {
                        maxEntropy = H;
                    }
                    ++i2;
                }
            }
            if (!operationsPerformed.isEmpty()) {
                int i3 = 0;
                while (i3 < operationsPerformed.size()) {
                    action = (PValueScoredGraphAction)operationsPerformed.get(i3);
                    Integer source = action.getV1();
                    Integer target = action.getV2();
                    double lineWidth = 1.0 + (action.entropy - minEntropy) / (maxEntropy - minEntropy) * 10.0;
                    out.println("\t\"" + source + "\" -- \"" + target + "\" [ penwidth=" + lineWidth + " ];");
                    ++i3;
                }
            }
            out.println("}");
            out.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    public BitSet findSab(GraphAction action) {
        int a = action.getV1();
        int b = action.getV2();
        BitSet Sab = null;
        for (CliqueGraphEdge e : this.graph.cg.edgeSet()) {
            BitSet clique1 = e.getClique1();
            BitSet clique2 = e.getClique2();
            if ((!clique1.get(a) || !clique2.get(b)) && (!clique2.get(a) || !clique1.get(b))) continue;
            Sab = e.getSeparator();
            break;
        }
        if (Sab == null) {
            Sab = new BitSet(this.dimensionsForVariables.length);
        }
        if (!Sab.equals(this.graph.getSeparator(a, b))) {
            System.err.println("Ouch");
        }
        return Sab;
    }

    public Double entropyDiffIfAdding(int a, int b, BitSet Sab, EntropyComputer computer) {
        BitSet Sabua = (BitSet)Sab.clone();
        BitSet Sabub = (BitSet)Sab.clone();
        BitSet Sabuaub = (BitSet)Sab.clone();
        Sabua.set(a);
        Sabub.set(b);
        Sabuaub.set(a);
        Sabuaub.set(b);
        Double entropy = 0.0;
        Double tmp = computer.computeEntropy(Sab);
        if (tmp == null) {
            entropy = null;
            return entropy;
        }
        entropy = entropy - tmp;
        tmp = computer.computeEntropy(Sabua);
        if (tmp == null) {
            entropy = null;
            return entropy;
        }
        entropy = entropy + tmp;
        tmp = computer.computeEntropy(Sabub);
        if (tmp == null) {
            entropy = null;
            return entropy;
        }
        entropy = entropy + tmp;
        tmp = computer.computeEntropy(Sabuaub);
        if (tmp == null) {
            entropy = null;
            return entropy;
        }
        entropy = entropy - tmp;
        return entropy;
    }

    public double messageLengthDiffIfAdding(Integer a, Integer b, MessageLengthFactorialComputer computer, boolean verbose) {
        BitSet Sab = this.graph.getSeparator(a, b);
        BitSet Sabua = (BitSet)Sab.clone();
        BitSet Sabub = (BitSet)Sab.clone();
        BitSet Sabuaub = (BitSet)Sab.clone();
        Sabua.set(a);
        Sabub.set(b);
        Sabuaub.set(a);
        Sabuaub.set(b);
        double lengthFrequencies = (double)this.nbParametersDiffIfAdding(a, b) * computer.getLogFromTable(computer.getNbInstances() + 1);
        double lengthPositionData = 0.0;
        lengthPositionData += computer.computeLengthData(Sab);
        lengthPositionData -= computer.computeLengthData(Sabua);
        lengthPositionData -= computer.computeLengthData(Sabub);
        assert ((lengthPositionData += computer.computeLengthData(Sabuaub)) >= 0.0);
        if (verbose) {
            System.out.println("adding (" + a + "," + b + ")");
            System.out.println("#param diff =  " + this.nbParametersDiffIfAdding(a, b));
            System.out.println("diff length frequencies=" + lengthFrequencies);
            System.out.println("diff length data|freq=" + lengthPositionData);
        }
        this.encodingLength = lengthFrequencies + lengthPositionData;
        return this.encodingLength;
    }

    public void saveAssociations(String[] variableNames, File f) throws IOException {
        int nbVertices = variableNames.length;
        boolean[][] association = new boolean[nbVertices][nbVertices];
        for (DefaultEdge edge : this.graph.edgeSet()) {
            association[((Integer)this.graph.getEdgeSource((Object)edge)).intValue()][((Integer)this.graph.getEdgeTarget((Object)edge)).intValue()] = true;
            association[((Integer)this.graph.getEdgeTarget((Object)edge)).intValue()][((Integer)this.graph.getEdgeSource((Object)edge)).intValue()] = true;
        }
        PrintWriter out = new PrintWriter(f);
        out.print("name");
        int i = 0;
        while (i < variableNames.length) {
            out.print("," + variableNames[i]);
            ++i;
        }
        out.println();
        i = 0;
        while (i < nbVertices) {
            out.print(variableNames[i]);
            int j = 0;
            while (j < nbVertices) {
                if (association[i][j]) {
                    out.print(",y");
                } else {
                    out.print(",n");
                }
                ++j;
            }
            out.println();
            ++i;
        }
        out.close();
    }
}

