% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_pcaSpectra.R
\name{r_pcaSpectra}
\alias{r_pcaSpectra}
\title{Robust PCA of a Spectra Object}
\usage{
r_pcaSpectra(spectra, choice = "noscale")
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra}}.}

\item{choice}{A character vector describing the type of scaling to be
carried out.  One of \code{c("noscale", "mad")}.}
}
\value{
An object of classes \code{converted_from_princomp} and \code{prcomp}.
It includes a list element called \code{$method}, a
character string describing the pre-processing carried out and the type of
PCA performed (used to annotate plots).
}
\description{
A wrapper which carries out robust PCA analysis on a \code{\link{Spectra}}
object.  The data are row- and column-centered, and the user can select
various options for scaling.
}
\examples{

data(metMUD1)
pca <- r_pcaSpectra(metMUD1)
plotScree(pca)
plotScores(metMUD1, pca, main = "metMUD1 NMR Data",
  pcs = c(1,2), ellipse = "cls", tol = 0.05)
plotLoadings(metMUD1, pca, main = "metMUD1 NMR Data",
	 loads = 1:2, ref = 1)

}
\references{
K. Varmuza and P. Filzmoser \emph{Introduction to Multivariate
Statistical Analysis in Chemometrics}, CRC Press, 2009.
}
\seealso{
\code{\link[pcaPP]{PCAgrid}} for the underlying function,
\code{\link{c_pcaSpectra}} for classical PCA calculations,
\code{\link{s_pcaSpectra}} for sparse PCA calculations,
\code{\link{irlba_pcaSpectra}} for PCA via the IRLBA algorithm.
Additional documentation at \url{https://bryanhanson.github.io/ChemoSpec/}

For displaying the results, \code{\link{plotScree}}, 
\code{\link{plotScores}}, \code{\link{plotLoadings}},
\code{\link{plot2Loadings}}, \code{\link{sPlotSpectra}},
\code{\link{plotScores3D}}, \code{\link{plotScoresRGL}}.

\url{https://bryanhanson.github.io/ChemoSpec/}
}
\author{
Bryan A. Hanson, DePauw University.
}
\keyword{multivariate}
\keyword{robust}
