% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfX_Exponential.R
\name{cfX_Exponential}
\alias{cfX_Exponential}
\title{Characteristic function of Exponential distribution}
\usage{
cfX_Exponential(t, lambda = 1)
}
\arguments{
\item{t}{numerical values (number, vector...)}

\item{lambda}{rate, lambda > 0, default value lambda = 1}
}
\value{
characteristic function cf(t) of the Exponential distribution
}
\description{
cfX_Exponential(t, lambda) evaluates the characteristic function cf(t) of
the Exponential distribution with the parameter lambda (rate, lambda > 0)

cfX_Exponential(t, lambda) = lambda / (lambda - it)
}
\examples{
## EXAMPLE1 (CF of the Exponential distribution with lambda = 5)
lambda <- 5
t <- seq(-10, 10, length.out = 501)
plotGraf(function(t)
  cfX_Exponential(t, lambda), t, title = "CF of the Exponential distribution with lambda = 5")

## EXAMPLE2 (PDF/CDF of the Exponential distribution with lambda = 5)
lambda <- 5
cf <- function(t)
  cfX_Exponential(t, lambda)
x <- seq(0, 1.5, length.out = 501)
result <- cf2DistGP(cf, x, SixSigmaRule = 8, xMin = 0)

## EXAMPLE3 (PDF/CDF of the compound Binomial-Exponential distribution)
n <- 25
p <- 0.3
lambda <- 5
cfX <- function(t)
  cfX_Exponential(t, lambda)
cf <- function(t)
  cfN_Binomial(t, n, p, cfX)
x <- seq(0, 5, length.out = 101)
prob <- c(0.9, 0.95, 0.99)
result <- cf2DistGP(cf, x, prob, isCompound = TRUE)
}
\seealso{
For more details see WIKIPEDIA:
\url{https://en.wikipedia.org/wiki/Exponential_distribution}

Other Continuous Probability distribution: \code{\link{cfS_Arcsine}},
  \code{\link{cfS_Beta}}, \code{\link{cfS_Gaussian}},
  \code{\link{cfS_Rectangular}},
  \code{\link{cfS_StudentT}},
  \code{\link{cfS_Trapezoidal}},
  \code{\link{cfS_Triangular}}, \code{\link{cfX_Beta}},
  \code{\link{cfX_ChiSquared}}, \code{\link{cfX_Gamma}},
  \code{\link{cfX_InverseGamma}},
  \code{\link{cfX_LogNormal}}, \code{\link{cfX_Normal}},
  \code{\link{cfX_PearsonV}},
  \code{\link{cfX_Rectangular}},
  \code{\link{cfX_Triangular}}
}

