% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfN_Poisson.R
\name{cfN_Poisson}
\alias{cfN_Poisson}
\title{Characteristic function of Poisson distribution}
\usage{
cfN_Poisson(t, lambda = 1, cfX)
}
\arguments{
\item{t}{numerical values (number, vector...)}

\item{lambda}{rate, lambda > 0, default value lambda = 1}

\item{cfX}{function}
}
\value{
characteristic function cf(t) of the Poisson distribution with rate lambda
}
\description{
cfN_Poisson(t, lambda) evaluates the characteristic function cf(t) of the
Poisson distribution with the rate parameter lambda > 0, i.e.
cfN_Poisson(t, lambda) = exp(lambda*(exp(1i*t)-1))

cfN_Poisson(t, lambda, cfX) evaluates the compound characteristic function
cf(t) = cfN_Poisson(-1i*log(cfX(t)), lambda), where cfX is function
handle of the characteristic function cfX(t) of a continuous distribution
and/or random variable X.

Note that such CF is characteristic function of the compound distribution,
i.e. distribution of the random variable Y = X_1 + ... + X_N, where X_i ~ F_X
are i.i.d. random variables with common CF cfX(t), and N ~ F_N is
independent RV with its CF given by cfN(t).
}
\examples{
## EXAMPLE1 (CF of the Poisson distribution with the parameter lambda = 10)
lambda <- 10
t <- seq(-10, 10, length.out = 501)
plotGraf(function(t)
  cfN_Poisson(t, lambda), t,
  title = "CF of the Poisson distribution with the parameter lambda = 10")

#' ## EXAMPLE2 (CF of the compound Poisson-Exponential distributionn)
lambda1 <- 10
lambda2 <- 5
cfX <- function(t)
  cfX_Exponential(t, lambda2)
t <- seq(-10, 10, length.out = 501)
plotGraf(function(t)
  cfN_Poisson(t, lambda1, cfX), t,
  title = "CF of the compound Poisson-Exponential distribution")

## EXAMPLE3 (PDF/CDF of the compound Poisson-Exponential distribution)
lambda1 <- 10
lambda2 <- 5
cfX <- function(t)
  cfX_Exponential(t, lambda2)
cf <- function(t)
  cfN_Poisson(t, lambda1, cfX)
x <- seq(0, 8, length.out = 101)
prob <- c(0.9, 0.95, 0.99)
result <- cf2DistGP(cf, x, prob, isCompound = TRUE)
}
\seealso{
For more details see WIKIPEDIA:
\url{https://en.wikipedia.org/wiki/Poisson_distribution}
\url{https://en.wikipedia.org/wiki/Compound_Poisson_distribution}

Other Discrete Probability Distribution: \code{\link{cfN_Binomial}},
  \code{\link{cfN_Delaporte}},
  \code{\link{cfN_GeneralizedPoisson}},
  \code{\link{cfN_Geometric}},
  \code{\link{cfN_Logarithmic}},
  \code{\link{cfN_NegativeBinomial}},
  \code{\link{cfN_PolyaEggenberger}}
}

