% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfN_Geometric.R
\name{cfN_Geometric}
\alias{cfN_Geometric}
\title{Characteristic function of Geometric distribution}
\usage{
cfN_Geometric(t, p = 1/2, type = "standard", cfX)
}
\arguments{
\item{t}{numerical values (number, vector...)}

\item{p}{success probability, \eqn{0 \le p \le 1}, default value p = 1/2}

\item{type}{standard = 1, shifted = 2, default type = standard}

\item{cfX}{function}
}
\value{
characteristic function cf(t) of the Geometric distribution with p success probability
}
\description{
cfN_Geometric(t, p, type, cfX) evaluates the characteristic function cf(t) of the
Geometric distribution.

 The standard Geometric distribution (type = "standard" or "zero") is
 defined on non-negative integers k = 0,1,... .

 The shifted Geometric distribution (type = "shifted")
 is defined on positive integers k = 1,2,... .

Both types are parametrized by the success probability parameter p in [0,1]), i.e.
cfN_Geometric(t, p, "standard") = p / (1 - (1-p) * exp(1i*t)),
cfN_Geometric(t, p, "shifted")  = exp(1i*t) * (p / (1 - (1-p) * exp(1i*t))).

cfN_Geometric(t, p, type, cfX) evaluates the compound characteristic function
cf(t) = Geometric(-1i*log(cfX(t)), p), where cfX is function
handle of the characteristic function cfX(t) of a continuous distribution
and/or random variable X.

Note that such CF is characteristic function of the compound distribution,
i.e. distribution of the random variable Y = X_1 + ... + X_N, where X_i ~ F_X
are i.i.d. random variables with common CF cfX(t), and N ~ F_N is
independent RV with its CF given by cfN(t).
}
\examples{
## EXAMPLE1 (CF of the Geometric distribution with the parameter p = 0.5)
p <- 0.5
t <- seq(-10, 10, length.out = 501)
plotGraf(function(t)
  cfN_Geometric(t, p), t,
  title = "CF of the Geometric distribution with the parameter p = 0.5")

## EXAMPLE2 (CF of the Geometric distribution with the parameter p = 0.5, type = "shifted")
p <- 0.5
t <- seq(-10, 10, length.out = 501)
plotGraf(function(t)
  cfN_Geometric(t, p, "shifted"), t,
  title = "CF of the Geometric distribution with the parameter p = 0.5")

## EXAMPLE3 (CF of the compound Geometric-Exponential distribution)
p <- 0.5
lambda <- 5
cfX <- function(t)
  cfX_Exponential(t, lambda)
t <- seq(-10, 10, length.out = 501)
plotGraf(function(t)
  cfN_Geometric(t, p, 1, cfX), t,
  title = "CF of the compound Geometric-Exponential distribution")

## EXAMPLE4 (PDF/CDF of the compound Geometric-Exponential distribution)
p <- 0.5
lambda <- 5
cfX <- function(t)
  cfX_Exponential(t, lambda)
cf <- function(t)
  cfN_Geometric(t, p, cfX = cfX)
x <- seq(0, 4, length.out = 101)
prob <- c(0.9, 0.95, 0.99)
result <- cf2DistGP(cf, x, prob, isCompound = TRUE)
}
\seealso{
For more details see WIKIPEDIA:
\url{https://en.wikipedia.org/wiki/Geometric_distribution}

Other Discrete Probability Distribution: \code{\link{cfN_Binomial}},
  \code{\link{cfN_Delaporte}},
  \code{\link{cfN_GeneralizedPoisson}},
  \code{\link{cfN_Logarithmic}},
  \code{\link{cfN_NegativeBinomial}},
  \code{\link{cfN_Poisson}},
  \code{\link{cfN_PolyaEggenberger}}
}

