% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hostParams.R
\name{hostParams}
\alias{hostParams}
\title{Create an NLME Parallel Host Configuration}
\usage{
hostParams(
  sharedDirectory,
  installationDirectory = Sys.getenv("INSTALLDIR"),
  hostName = Sys.info()[["nodename"]],
  machineName = "127.0.0.1",
  hostType = Sys.info()[["sysname"]],
  numCores = 4,
  parallelMethod = "LOCAL_MPI",
  userName = "",
  privateKeyFile = NULL,
  userPassword = "",
  scriptPath = "",
  rLocation = "",
  isLocal = TRUE
)
}
\arguments{
\item{sharedDirectory}{\code{character}. The directory where temporary run folders
are created. Defaults to the current working directory.}

\item{installationDirectory}{\code{character}. The directory containing NLME
libraries/scripts. Defaults to the \code{INSTALLDIR} environment variable.}

\item{hostName}{\code{character}. A display name for the host. Defaults to the
system's network name (from \code{Sys.info()[["nodename"]]}).}

\item{machineName}{\code{character}. The IP address or network name of the host.
Defaults to \code{"127.0.0.1"}.}

\item{hostType}{\code{character}. The host operating system. Defaults to the
current OS (\code{Sys.info()[["sysname"]]}). While \code{"windows"} or \code{"linux"} are
valid, for remote Linux hosts the following are officially supported:
\code{"RHEL"} (for RHEL 8 and 9) and \code{"UBUNTU"} (for Ubuntu 22.04 and 24.04).
Specifying one of these values correctly sets the \code{PML_BIN_DIR} variable.}

\item{numCores}{\code{numeric}. The number of CPU cores to utilize. Defaults to
\code{4}.}

\item{parallelMethod}{\code{character}. The parallel execution method. Options
include: \code{"None"}, \code{"Multicore"}, \code{"LOCAL_MPI"}, \code{"SGE"}, \code{"SGE_MPI"},
\code{"TORQUE"}, \code{"TORQUE_MPI"}, \code{"LSF"}, \code{"LSF_MPI"}, \code{"SLURM"}, \code{"SLURM_MPI"}.
Defaults to \code{"LOCAL_MPI"}.}

\item{userName}{\code{character}. The username for remote host authentication.}

\item{privateKeyFile}{\code{character}. The path to an SSH private key file for
remote authentication. See \code{ssh::ssh_connect()} for more details.}

\item{userPassword}{\code{character} or \code{function}. The password or a callback
function for remote authentication. See \code{ssh::ssh_connect()} for details.}

\item{scriptPath}{\code{character}. The path to a script to run on a remote host
before the main job starts. Ignored for local runs.}

\item{rLocation}{\code{character}. The path to the \code{Rscript} executable on a
remote host. Ignored for local runs.}

\item{isLocal}{\code{logical}. Set to \code{TRUE} for a local host or \code{FALSE} for a
remote host. Defaults to \code{TRUE}.}
}
\value{
An \code{NlmeParallelHost} object configured with the specified
parameters.
}
\description{
This helper function simplifies the creation and configuration of an
\code{NlmeParallelHost} object, which defines the environment for running NLME
jobs.
}
\examples{
host <- hostParams(sharedDirectory = tempdir(),
                   parallelMethod = "LOCAL_MPI",
                   hostName = "Local",
                   numCores = 4)

}
\keyword{NLME}
\keyword{NlmeParallelHost}
