% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dosing.r
\docType{class}
\name{DosePoint-class}
\alias{DosePoint-class}
\alias{DosePoint}
\title{Defines a dosepoint for a compartment}
\arguments{
\item{isZeroOrderAbsorption}{One of No|RateDose|DurationDose}

\item{isBioavail}{Does dose point has bioavailability?}

\item{bioavailExpression}{Bioavailability expression}

\item{isTlag}{Does dose have time lag?}

\item{tlagExpression}{Time lag expression}

\item{durationExpression}{Optional Formula defines how to express duration in PML}

\item{rateExpression}{Optional Formula defines how to express rate in PML}

\item{dobefore}{Code to execute before dose is administrated}

\item{doafter}{Code to execute after dose is administrated}
}
\description{
Defines a dosepoint for a compartment
}
\examples{
\donttest{
dosePoint <- DosePoint(
  isZeroOrderAbsorption = DurationDose,
  durationExpression = "DUR",
  isTlag = FALSE,
  isBioavail = TRUE,
  bioavailExpression = "logitF1;1-ilogit(logitF1)"
)

absDosePoint <- DosePoint(
  isZeroOrderAbsorption = NoDose,
  isBioavail = TRUE,
  bioavailExpression = "logitF1;ilogit(logitF1)"
)
}
}
\keyword{internal}
