% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_events.R
\name{make_events}
\alias{make_events}
\title{Make data in compact form}
\usage{
make_events(
  model,
  n = 1,
  w = NULL,
  P = NULL,
  A = NULL,
  parameters = NULL,
  param_type = NULL,
  include_strategy = FALSE,
  ...
)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by
\code{\link{make_model}}.}

\item{n}{An integer. Number of observations.}

\item{w}{A numeric matrix. A `n_parameters x 1` matrix of event
probabilities with named rows.}

\item{P}{A \code{data.frame}. Parameter matrix. Not required but may be
provided to avoid repeated computation for simulations.}

\item{A}{A \code{data.frame}. Ambiguity matrix. Not required but may be
provided to avoid repeated computation for simulations.}

\item{parameters}{A vector of real numbers in [0,1]. Values of parameters to
specify (optional). By default, parameters is drawn from
\code{model$parameters_df}.}

\item{param_type}{A character. String specifying type of parameters to make
'flat', 'prior_mean', 'posterior_mean', 'prior_draw', 'posterior_draw',
'define. With param_type set to \code{define} use arguments to be passed
to \code{make_priors}; otherwise \code{flat} sets equal probabilities on
each nodal type in each parameter set; \code{prior_mean},
\code{prior_draw}, \code{posterior_mean}, \code{posterior_draw} take
parameters as the means or as draws from the prior or posterior.}

\item{include_strategy}{Logical. Whether to include a 'strategy' vector.
Defaults to FALSE. Strategy vector does not vary with full data but
expected by some functions.}

\item{...}{Arguments to be passed to make_priors if
param_type == \code{define}}
}
\value{
A \code{data.frame} of events
}
\description{
Draw \code{n} events given event probabilities.
Draws full data only. For incomplete data see
\code{\link{make_data}}.
}
\examples{
\donttest{
model <- make_model('X -> Y')
make_events(model = model)
make_events(model = model, param_type = 'prior_draw')
make_events(model = model, include_strategy = TRUE)
}

}
