% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_prior_distribution.R
\name{get_prior_distribution}
\alias{get_prior_distribution}
\title{Get a prior distribution from model}
\usage{
get_prior_distribution(model, n_draws = 4000)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by
\code{\link{make_model}}.}

\item{n_draws}{A scalar. Number of draws.}
}
\value{
A `data.frame` with dimension `n_param`x `n_draws` of possible
  lambda draws
}
\description{
Access the prior distribution from the model if one has been added via `set_prior_distribution`.
Otherwise call  `make_prior_distribution` to generate and return an `n_draws x n_param`  prior distribution.
}
\seealso{
Other prior_distribution: 
\code{\link{make_prior_distribution}()},
\code{\link{set_prior_distribution}()}
}
\concept{prior_distribution}
\keyword{internal}
