% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_confounds_df.R
\name{make_confounds_df}
\alias{make_confounds_df}
\title{Make a confounds dataframe}
\usage{
make_confounds_df(model)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by \code{\link{make_model}}.}
}
\value{
A \code{data.frame} indicating which nodes are confounded
}
\description{
Identifies confounded nodal types.
}
\examples{
\donttest{
model <- make_model('X -> Y') \%>\%
set_confound('X <-> Y', add_confounds_df  = FALSE)
make_confounds_df(model)

model <- make_model('X -> M -> Y; X <-> Y') \%>\%
set_restrictions(c('M[X=1] == M[X=0]', 'Y[M=1]==Y[M=0]'))
make_confounds_df(model)

model <- make_model('X -> M -> Y; X <-> M; M <-> Y') \%>\%
set_restrictions(c('M[X=1] == M[X=0]', 'Y[M=1]==Y[M=0]'))
make_confounds_df(model)

# The implied confounding is between X and M and also between X and Y
model <- make_model('X -> M -> Y') \%>\%
  set_confound(list(X = 'Y[X=1] > Y[X=0]'), add_confounds_df = FALSE)
make_confounds_df(model)

model <- make_model('X -> M -> Y')
make_confounds_df(model)
}
# Bad case
\dontrun{
model <- make_model('X -> Y') \%>\%
  set_confound(list(X = 'X==1'))
}

# Complex confounding 1
model <- make_model('A -> X <- B ; A <-> X; B <-> X')
model$confounds_df

# Complex confounding 2
model <- make_model('A <- X -> B; A <-> X; B <-> X') \%>\%
set_restrictions(c('A[X=0] == A[X=1]', 'B[X=0] == B[X=1]'))
table(model$parameters_df$param_set)
model$confounds_df

# Full confounding: X, A|X, B|A,X with 7 degrees of freedom
model <- make_model('A <- X -> B; A <-> X; B <-> X; A<->B') \%>\%
set_restrictions(c('A[X=0] == A[X=1]', 'B[X=0] == B[X=1]'))
table(model$parameters_df$param_set)
model$confounds_df
}
