% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gestimation.R
\name{gestimation}
\alias{gestimation}
\title{One Parameter G-Estimation of Structural Nested Mean Models}
\usage{
gestimation(
  data,
  grid,
  ids = list(),
  f = NA,
  family = binomial(),
  simple = pkg.env$simple,
  p.f = NA,
  p.simple = pkg.env$simple,
  p.family = binomial(),
  p.scores = NA,
  SW = TRUE,
  n.boot = 100,
  type = "one.grid",
  ...
)
}
\arguments{
\item{data}{a data frame containing the variables in the model.
This should be the same data used in \code{\link[=init_params]{init_params}}.}

\item{grid}{a list of possible \eqn{\beta} values that will be used in the grid search.}

\item{ids}{(optional) see documentation for \code{\link[geepack:geeglm]{geeglm}}. By default rownames of the data will be used.}

\item{f}{(optional) an object of class "formula" that overrides the default parameter. NOTE: for g-estimation this should be
a propensity formula.}

\item{family}{the family to be used in the general linear model.
By default, this is set to \code{\link[stats:gaussian]{gaussian}}.}

\item{simple}{(optional) a boolean indicator to build default formula with interactions for the g-estimation model.
If true, interactions will be excluded. If false, interactions will be included. By default, simple is set to false.
NOTE: \eqn{\beta}  will be appended to the end of the formula}

\item{p.f}{(optional) an object of class "formula" that overrides the default formula for the denominator of the IP
weighting function.}

\item{p.simple}{(optional) a boolean indicator to build default formula with interactions for the propensity models.
If true, interactions will be excluded. If false, interactions will be included. By
default, simple is set to false.
NOTE: if this is changed, the coefficient for treatment may not accurately represent the average causal effect.}

\item{p.family}{the family to be used in the underlying propensity model.
By default, this is set to \code{\link[stats:binomial]{binomial}}.}

\item{p.scores}{(optional) use calculated propensity scores for the weights. If using standardized weights,
the numerator will still be modeled.}

\item{SW}{a boolean indicator to indicate the use of standardized weights. By default, this is set to true.}

\item{n.boot}{(optional) an integer value that indicates number of bootstrap iterations to calculate standard error.
If no value is given, the standard error from the underlying linear model will be used. NOTE: when type is 'one.grid'
bootstrapping is not performed. By default, this is set to 100.}

\item{type}{the type of g-estimation to perform. It must be one of \code{"one.grid"} or \code{"one.linear"} for a
one parameter grid and linear mean model estimation respectively.}

\item{...}{additional arguments that may be passed to the underlying model.}
}
\value{
\code{gestimation} returns an object of \code{\link[base:class]{class} "gestimation"}.

The functions \code{print}, \code{summary}, and \code{predict} can be used to interact with
the underlying \code{glm} or \code{geeglm} model.

An object of class \code{"gestimation"} is a list containing the following:

 \item{call}{the matched call.}
 \item{formula}{the formula used in the model.}
 \item{model}{the underlying glm model. If the model performed a grid search, this will be renamed 'best.model'}
 \item{weights}{the estimated IP weights.}
 \item{type}{returns the value used for the 'type' parameter.}
 \item{ATE}{the estimated average treatment effect (risk difference).}
 \item{ATE.summary}{a data frame containing the ATE, SE, and 95\% CI of the ATE. }
}
\description{
`gestimation` uses the \code{\link[=propensity_scores]{propensity_scores}} function to generate inverse probability
weights. The weights can either be standardized weights or non-standardized weights. A grid search is done on \eqn{\alpha}
to construct the best \eqn{\beta} coefficient in the structural nested mean model. Alternatively, a linear mean model can be used
for a closed form estimator.
}
\examples{
library(causaldata)
data(nhefs)
nhefs.nmv <- nhefs[which(!is.na(nhefs$wt82)), ]
nhefs.nmv$qsmk <- as.factor(nhefs.nmv$qsmk)

confounders <- c(
  "sex", "race", "age", "education", "smokeintensity",
  "smokeyrs", "exercise", "active", "wt71"
)

init_params(wt82_71, qsmk,
  covariates = confounders,
  data = nhefs.nmv
)

gest.model <- gestimation(nhefs.nmv, type = "one.linear", n.boot = 150)
gest.model$ATE.summary
}
